/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Axis;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CategoricalAxisRenderer {
    public static final int LABEL_INDEX = 2;
    public static final int MAX_EMBEDDED_COMPONENTS = 100;
    private static final String VARIABLE_PATTERN = "[a-zA-Z][a-zA-Z0-9_]*";
    private final CompilationContext context;
    private final File gen;
    private final File res;

    public CategoricalAxisRenderer(CompilationContext context, File gen, File res) {
        this.context = context;
        this.gen = gen;
        this.res = res;
    }

    public void render(Axis.Categorical axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"axis"});
        this.addBasicAxisInfo(fb, axis);
        this.handleIncludes(fb, axis);
        this.writeAxisFrame(fb, axis);
        this.addToCompiledFiles(axis);
    }

    private void addBasicAxisInfo(FrameBuilder fb, Axis.Categorical axis) {
        fb.add("package", (Object)this.context.packageName()).add("name", (Object)axis.name$()).add("label", (Object)axis.label());
        if (axis.asAxis().isDynamic()) {
            fb.add("dynamic", (Object)";");
        }
    }

    private void writeAxisFrame(FrameBuilder fb, Axis.Categorical axis) {
        Commons.writeFrame(new File(this.gen, "axes"), StringFormatters.pascalCase().format((Object)axis.name$()).toString(), new CategoricalAxisTemplate().render(fb.toFrame(), Formatters.all));
    }

    private void addToCompiledFiles(Axis.Categorical axis) {
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(axis), Commons.javaFile(new File(this.gen, "axes"), this.getJavaFilename(axis)).getAbsolutePath()));
    }

    private void handleIncludes(FrameBuilder fb, Axis.Categorical axis) {
        this.addLabel(fb, axis);
        List<Axis> includes = axis.include() == null ? Collections.emptyList() : axis.include().axes();
        this.loadComponents(fb, axis, includes);
        this.addIncludes(fb, axis, includes);
    }

    private void loadComponents(FrameBuilder fb, Axis.Categorical axis, List<Axis> includes) {
        String resource = "/" + this.axisResource(axis.tsv().getPath());
        List<ComponentInfo> components = this.loadFromResource(resource);
        boolean embedded = this.isSmallEnough(components);
        if (embedded) {
            this.createEmbeddedComponents(fb, axis, includes, components);
        }
        FrameBuilder componentsFB = new FrameBuilder(new String[]{"components"});
        componentsFB.add("name", (Object)axis.name$());
        this.addLabel(componentsFB, axis);
        componentsFB.add("embedded", (Object)embedded);
        if (embedded) {
            this.addEmbeddedComponentsToArray(componentsFB, axis, components);
        } else {
            componentsFB.add("resource", (Object)resource);
            this.addIncludes(componentsFB, axis, includes);
        }
        fb.add("components", (Object)componentsFB);
    }

    private void addLabel(FrameBuilder fb, Axis.Categorical axis) {
        if (axis.includeLabel() != null) {
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("axis", (Object)axis.name$()).add("name", (Object)"label").add("label", (Object)"label").add("index", (Object)2));
        }
    }

    private void addIncludes(FrameBuilder fb, Axis.Categorical axis, List<Axis> includes) {
        int offset = this.offset(axis);
        for (int i = 0; i < includes.size(); ++i) {
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("axis", (Object)axis.name$()).add("name", (Object)includes.get(i).name$()).add("type", (Object)(includes.get(i).isCategorical() ? "categorical" : "continuous")).add("label", (Object)this.asFieldName(includes.get(i).label())).add("index", (Object)(i + offset)));
        }
    }

    private void addIncludes(ComponentInfo component, FrameBuilder fb, Axis.Categorical axis, List<Axis> includes) {
        boolean hasLabel = axis.includeLabel() != null;
        int offset = this.offset(axis);
        for (int i = 0; i < includes.size(); ++i) {
            String include = component.field(i + (hasLabel ? 3 : 2));
            fb.add("include", (Object)new FrameBuilder(new String[]{"include"}).add("name", (Object)includes.get(i).name$()).add("label", (Object)this.asFieldName(includes.get(i).label())).add("id", (Object)include).add("type", (Object)(includes.get(i).isCategorical() ? "categorical" : "continuous")).add("index", (Object)(i + offset)));
        }
    }

    private void addEmbeddedComponentsToArray(FrameBuilder fb, Axis.Categorical axis, List<ComponentInfo> components) {
        boolean useLabel = this.shouldUseLabel(axis, components);
        for (ComponentInfo component : components) {
            String name = useLabel ? component.label() : component.id();
            fb.add("component", (Object)this.asFieldName(name));
        }
    }

    private void createEmbeddedComponents(FrameBuilder fb, Axis.Categorical axis, List<Axis> includes, List<ComponentInfo> components) {
        boolean useLabel = this.shouldUseLabel(axis, components);
        for (ComponentInfo component : components) {
            FrameBuilder compFB = new FrameBuilder(new String[]{"component"});
            String name = useLabel ? component.label() : component.id();
            compFB.add("name", (Object)this.asFieldName(name));
            if (axis.includeLabel() != null) {
                compFB.add("label", (Object)component.label());
            }
            compFB.add("index", (Object)component.index());
            compFB.add("id", (Object)component.id());
            this.addIncludes(component, compFB, axis, includes);
            fb.add("component", (Object)compFB);
        }
    }

    private boolean shouldUseLabel(Axis.Categorical axis, List<ComponentInfo> components) {
        return axis.includeLabel() != null && axis.includeLabel().isName() && this.checkLabelNames(components);
    }

    private boolean checkLabelNames(List<ComponentInfo> components) {
        for (ComponentInfo component : components) {
            if (this.asFieldName(component.label()).matches(VARIABLE_PATTERN)) continue;
            return false;
        }
        return true;
    }

    private String asFieldName(String name) {
        name = name.replaceAll("\\s+", "_").replace('-', '_');
        return Character.isDigit((name = StringUtils.stripAccents((String)name)).charAt(0)) ? "_" + name : name;
    }

    private boolean isSmallEnough(List<ComponentInfo> components) {
        return components.size() <= 100;
    }

    private List<ComponentInfo> loadFromResource(String resource) {
        List<ComponentInfo> list;
        String fullResourcePath = new File(this.res, resource).getAbsolutePath();
        BufferedReader reader = new BufferedReader(new FileReader(fullResourcePath));
        try {
            list = reader.lines().map(line -> line.split("\t")).map(ComponentInfo::new).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    private String axisResource(String resource) {
        Path res = this.context.res(Target.Server).toPath();
        return res.relativize(new File(resource).toPath().toAbsolutePath()).toFile().getPath().replace("\\", "/");
    }

    private int offset(Axis.Categorical axis) {
        return axis.includeLabel() != null ? 3 : 2;
    }

    private String getJavaFilename(Axis.Categorical axis) {
        return StringFormatters.pascalCase().format((Object)axis.name$()).toString();
    }

    private static class ComponentInfo {
        private final String[] fields;

        public ComponentInfo(String[] fields) {
            this.fields = fields;
        }

        public int index() {
            return Integer.parseInt(this.field(0));
        }

        public String id() {
            return this.field(1);
        }

        public String field(int index) {
            return this.fields[index];
        }

        public String label() {
            return this.fields[2];
        }
    }
}

