/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.web.templates;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AppTemplate
extends Template {
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"app"})).output(new Output[]{Outputs.literal((String)"__webpack_public_path__ = loadAppUrl();\n\nimport React from \"react\";\nimport ReactDOM from \"react-dom\";\n")}).output(new Output[]{Outputs.placeholder((String)"page", (String[])new String[]{"import"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\nimport PushService from \"alexandria-ui-elements/src/services/PushService\";\nimport FileService from \"alexandria-ui-elements/src/services/FileService\";\nimport TranslatorService from \"alexandria-ui-elements/src/services/TranslatorService\";\nimport GoogleApiLoader from \"alexandria-ui-elements/src/displays/components/geo/GoogleApiLoader\";\nimport DisplayRouter from \"alexandria-ui-elements/src/displays/DisplayRouter\";\n\nvar launchApplication = function () {\n\tvar configuration = loadConfiguration();\n\n\twindow.Application = (function(configuration) {\n\t\tvar self = {};\n\n\t\tself.configuration = configuration;\n\t\tself.configuration.appUrls = loadUrls(configuration.baseUrls);\n\t\tself.configuration.appUrl = (app) => {\n\t\t\treturn self.configuration.appUrls[app] != null ? self.configuration.appUrls[app] : self.configuration.baseUrl;\n\t\t};\n\t\tself.services = {\n\t\t\tpushService: PushService,\n\t\t\tfileService: FileService.create(configuration),\n\t\t\ttranslatorService: TranslatorService.create(configuration)\n\t\t};\n\n\t\treturn self;\n\t})(configuration);\n\n\trenderApplication();\n\n\tfunction loadConfiguration() {\n\t\treturn document.configuration;\n\t}\n\n\tfunction loadUrls(urlList) {\n\t\tlet result = {};\n\t\tif (urlList == null) return result;\n\t\tfor (let i=0; i<urlList.length; i++) {\n\t\t\tconst urlInfo = urlList[i].split(\"_##_\");\n\t\t\tresult[urlInfo[0]] = urlInfo[1];\n\t\t}\n\t\treturn result;\n\t}\n\n\tfunction renderApplication() {\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"page", (String[])new String[]{"render"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\t}\n\n\tfunction openPushService() {\n\t\twindow.setTimeout(() => {\n\t\t\tconst pushConnections = Application.configuration.pushConnections;\n\t\t\tfor (let i=0; i<pushConnections.length; i++) {\n\t\t\t\tconst connection = pushConnections[i].split(\"_##_\");\n\t\t\t\tif (connection[0].toLowerCase() !== \"default\") continue;\n\t\t\t\tPushService.openConnection(connection[0], connection[1]);\n\t\t\t}\n\t\t}, 100);\n\t}\n\n};\n\nfunction loadAppUrl() {\n\tlet url = window.location.pathname !== \"/\" ? window.location.pathname : \"\";\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"pattern", (String[])new String[0]).multiple("\n")})}).output(new Output[]{Outputs.literal((String)"\n\tif (url.lastIndexOf(\"/\") > 0) url = url.substr(0, window.location.pathname.lastIndexOf('/'));\n\tif (url === \"/\") url = \"\";\n\treturn url + \"/")}).output(new Output[]{Outputs.placeholder((String)"serviceName", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"/\";\n}\n\nlaunchApplication();")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"pattern"})).output(new Output[]{Outputs.literal((String)"url = url.replace(new RegExp(\"")}).output(new Output[]{Outputs.placeholder((String)"value", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", 'g'), \"\");")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"page"}), (LogicalExpression)Predicates.trigger((String)"import"))).output(new Output[]{Outputs.literal((String)"import ")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Page from \"../pages/")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Page\";")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"page"}), (LogicalExpression)Predicates.trigger((String)"render"))).output(new Output[]{Outputs.literal((String)"const requireGoogleApi = Application.configuration.googleApiKey != null && Application.configuration.googleApiKey !== \"\";\nconst content = requireGoogleApi ? <GoogleApiLoader onLoad={openPushService()}><")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Page/></GoogleApiLoader> : <")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Page/>;\nconst ")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)" = document.getElementById(\"")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"\");\nif (")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)") ReactDOM.render(<DisplayRouter id=\"__router__\" owner={()=>\"\"} context={()=>\"\"}>{content}</DisplayRouter>, ")}).output(new Output[]{Outputs.placeholder((String)"templateName", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)");\nif (!requireGoogleApi) openPushService();")}));
        return rules;
    }

    public String render(Object object) {
        return new Engine((Template)this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine((Template)this).addAll(formatters).render(object);
    }
}

