/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.AppTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Service;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppRenderer
extends UIRenderer {
    private final List<Service.UI> serviceList;
    private static final Map<String, List<String>> ComponentPropertiesMap = new HashMap<String, List<String>>(){
        {
            this.put("Alexandria", List.of("name", "label", "format", "color", "visible", "traceable", "style", "context", "owner", "multiple_instances", "multiple_arrangement", "multiple_no_items_message", "multiple_spacing", "multiple_editable", "multiple_wrap", "multiple_collapsed", "multiple_count_min", "multiple_count_max", "highlighted", "highlighted_background"));
            this.put("Actionable:Alexandria", List.of("title", "target", "mode", "icon", "affirmed", "traceable", "signed", "size", "highlighted", "readonly"));
            this.put("AbstractSlider:Alexandria", List.of("traceable", "arrangement", "animation", "readonly", "position", "style"));
            this.put("AppDirectory:Alexandria", List.of("icon"));
            this.put("Dashboard:Alexandria", List.of("width", "height"));
            this.put("OpenPopover:Alexandria", List.of("trigger_event"));
            this.put("SignText:Alexandria", List.of("content", "format"));
            this.put("Template:Alexandria", List.of("layout", "width", "height", "spacing"));
            this.put("BaseStamp:Alexandria", List.of("spacing"));
            this.put("MaterialIcon:Alexandria", List.of("icon"));
            this.put("Selector:Alexandria", List.of("multiple_selection", "readonly", "focused", "placeholder", "selected", "layout", "size", "max_menu_height", "allow_other", "scroll_buttons", "view"));
            this.put("Image:Alexandria", List.of("width", "height", "mobile_reduce_factor", "allow_full_screen"));
            this.put("File:Alexandria", List.of("width", "height", "preview", "drop_zone", "max_size", "allowed_types"));
            this.put("Chart:Alexandria", List.of("width", "height"));
            this.put("AlertDialog:Alexandria", List.of("title", "modal", "full_screen", "message", "close_label", "accept_label", "width", "height", "animation"));
            this.put("AbstractDialog:Alexandria", List.of("title", "modal", "full_screen", "width", "height", "animation"));
            this.put("Block:Alexandria", List.of("layout", "width", "height", "animation", "hidden", "auto_size", "paper"));
            this.put("Date:Alexandria", List.of("pattern", "mode", "value", "time_picker", "mask", "embedded", "allow_empty", "views", "shrink"));
            this.put("User:Alexandria", List.of("mode"));
            this.put("Number:Alexandria", List.of("value", "prefix", "suffix", "min", "max", "step", "readonly", "focused", "decimals", "expanded", "helper_text", "shrink"));
            this.put("Header:Alexandria", List.of("position", "width", "height", "elevation"));
            this.put("Code:Alexandria", List.of("mode", "language", "highlighted"));
            this.put("Text:Alexandria", List.of("mode", "edition_mode", "max_length", "rows", "prefix", "suffix", "translate", "crop_with_ellipsis", "value", "placeholder", "readonly", "focused", "highlighted", "type", "helper_text", "shrink", "pattern"));
            this.put("Location:Alexandria", List.of("center", "zoom", "modes", "controls"));
            this.put("Collection:Alexandria", List.of("no_items_message", "no_items_found_message", "page_size", "item_height", "scrolling_mark", "navigable", "selection"));
            this.put("Map:Collection", List.of("page_size", "type", "item_height", "center", "zoom", "controls"));
            this.put("Heading:Alexandria", List.of("style", "hidden"));
            this.put("Item:Alexandria", List.of("style", "hidden"));
            this.put("Spinner:Alexandria", List.of("mode", "size"));
            this.put("Switch:Alexandria", List.of("state"));
            this.put("Toggle:Alexandria", List.of("state"));
            this.put("SplitButton:Actionable", List.of("options", "default_option"));
            this.put("Export:Alexandria", List.of("from", "to", "min", "max", "range", "options"));
            this.put("Download:Alexandria", List.of("options"));
            this.put("SearchBox:Alexandria", List.of("placeholder", "show_count_message"));
            this.put("Slider:Alexandria", List.of("range", "value"));
            this.put("Grouping:Alexandria", List.of("page_size", "placeholder"));
            this.put("Stepper:Alexandria", List.of("orientation", "position"));
            this.put("Frame:Alexandria", List.of("width", "height", "url"));
            this.put("Sorting:Alexandria", List.of("mode", "align"));
            this.put("HtmlViewer:Alexandria", List.of("content"));
            this.put("Microsite:Alexandria", List.of("download_operations"));
        }
    };

    protected AppRenderer(CompilationContext compilationContext, List<Service.UI> serviceList) {
        super(compilationContext);
        this.serviceList = serviceList;
    }

    @Override
    public void render() {
        this.writeManifest(this.buildFrame().add("manifest"));
        this.writeSettingsGradle(this.buildFrame().add("settings"));
        this.writeAndroidGradle(this.buildFrame().add("android"));
        this.writeSharedGradle(this.buildFrame().add("shared"));
        this.writeProperties(this.buildFrame().add("properties"));
        this.writeStrings(this.buildFrame().add("strings"));
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder result = super.buildFrame();
        result.add("gradle");
        result.add("project", (Object)this.context.project());
        this.resources().stream().filter(Service.UI.Resource::isPage).forEach(r -> result.add("resource", (Object)this.resourceFrame((Service.UI.Resource)((Object)r))));
        return result;
    }

    private List<Service.UI.Resource> resources() {
        return this.serviceList.stream().map(Service.UI::resourceList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private FrameBuilder resourceFrame(Service.UI.Resource resource) {
        FrameBuilder result = this.buildBaseFrame().add("resource");
        if (resource.isMain()) {
            result.add("main");
        }
        result.add("name", (Object)resource.name$());
        return result;
    }

    private void writeManifest(FrameBuilder builder) {
        Commons.write(new File(String.valueOf(this.root(Target.Android)) + this.context.androidRelativePath() + File.separator + "AndroidManifest.xml").toPath(), new AppTemplate().render(builder.toFrame(), Formatters.all));
    }

    private void writeSettingsGradle(FrameBuilder builder) {
        Commons.write(new File(String.valueOf(this.root(Target.Android)) + File.separator + "settings.gradle.kts").toPath(), new AppTemplate().render(builder.toFrame(), Formatters.all));
    }

    private void writeAndroidGradle(FrameBuilder builder) {
        Commons.write(new File(String.valueOf(this.root(Target.Android)) + File.separator + "android" + File.separator + "build.gradle.kts").toPath(), new AppTemplate().render(builder.toFrame(), Formatters.all));
    }

    private void writeSharedGradle(FrameBuilder builder) {
        Commons.write(new File(String.valueOf(this.root(Target.Android)) + File.separator + "shared" + File.separator + "build.gradle.kts").toPath(), new AppTemplate().render(builder.toFrame(), Formatters.all));
    }

    private void writeProperties(FrameBuilder builder) {
        this.addProperties(builder);
        Commons.write(new File(String.valueOf(this.res(Target.Android)) + File.separator + "values" + File.separator + "properties.xml").toPath(), new AppTemplate().render(builder.toFrame(), Formatters.all));
    }

    private void writeStrings(FrameBuilder builder) {
        Commons.write(new File(String.valueOf(this.res(Target.Android)) + File.separator + "values" + File.separator + "strings.xml").toPath(), new AppTemplate().render(builder.toFrame(), Formatters.all));
    }

    private void addProperties(FrameBuilder builder) {
        ComponentPropertiesMap.forEach((c, attributes) -> builder.add("component", (Object)this.componentFrameOf((String)c, (List<String>)attributes)));
    }

    private FrameBuilder componentFrameOf(String component, List<String> attributes) {
        FrameBuilder result = new FrameBuilder(new String[]{"component"});
        String name = component.split(":")[0];
        String parent = component.split(":").length > 1 ? component.split(":")[1] : null;
        result.add("name", (Object)name);
        if (parent != null) {
            result.add("parent", (Object)parent);
        }
        attributes.forEach(a -> result.add("attribute", (Object)this.attributeFrame(name, parent, (String)a)));
        return result;
    }

    private FrameBuilder attributeFrame(String componentName, String componentParent, String attribute) {
        FrameBuilder result = new FrameBuilder(new String[]{"attribute"});
        result.add("name", (Object)attribute);
        result.add("component", (Object)componentName);
        return result;
    }
}

