/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.SchemaTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaWriter;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Schema;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public class AndroidSchemaWriter
extends SchemaWriter {
    private static final Logger LOG = Logger.getGlobal();

    public AndroidSchemaWriter(CompilationContext context) {
        super(context, context.gen(Target.MobileShared), context.packageName() + ".mobile.schemas");
    }

    @Override
    public void write(Schema schema, Frame frame) {
        try {
            File packageFolder = this.schemaFolder(schema);
            String content = new Engine((Template)new SchemaTemplate()).add("typeFormat", this.typeFormatter()).render((Object)new FrameBuilder(new String[]{"root"}).add("root", (Object)this.packageName).add("package", (Object)this.packageName).add("schema", (Object)frame));
            packageFolder.mkdirs();
            File file = Commons.kotlinFile(packageFolder, schema.name$());
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(schema), Commons.kotlinFile(packageFolder, schema.name$()).getAbsolutePath()));
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
    }

    private Formatter typeFormatter() {
        return value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        };
    }
}

