/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android;

import io.intino.itrules.Engine;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.AbstractDesktopSkeletonTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.AbstractDisplaySkeletonTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.ComponentTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.DisplaySkeletonTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.PassiveViewNotifierTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.PassiveViewRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.UiRendererWriter;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.dsl.PassiveView;
import io.intino.konos.dsl.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;

public class AndroidRendererWriter
extends UiRendererWriter {
    public AndroidRendererWriter(CompilationContext context) {
        super(context, Target.Android);
    }

    @Override
    public boolean write(Layer element, String type, FrameBuilder builder) {
        this.writeSrc(element, type, builder);
        this.writeGen(element, type, builder);
        this.writeLayout(element, type, builder);
        this.writeShared(element, type, builder);
        return true;
    }

    @Override
    public boolean writeNotifier(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Notifier");
        if (!this.hasConcreteNotifier(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayNotifierFolder(this.src(Target.MobileShared), this.target), element, name, new PassiveViewNotifierTemplate().render(frame, Formatters.all));
        return true;
    }

    @Override
    public boolean writeRequester(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Requester");
        if (!this.hasConcreteRequester(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayRequesterFolder(this.gen(Target.MobileShared), this.target), element, name, new PassiveViewRequesterTemplate().render(frame, Formatters.all));
        return true;
    }

    @Override
    public boolean writePushRequester(PassiveView element, FrameBuilder builder) {
        return false;
    }

    private void writeSrc(Layer element, String type, FrameBuilder builder) {
        Template template = this.srcTemplate(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        File file = CodeGenerationHelper.displayFile(this.src(), newDisplay, type, this.target);
        if (!element.i$(io.intino.konos.dsl.Template.class) && file.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.src(), type, this.target), element, newDisplay, new Engine(template).addAll(Formatters.all).render((Object)builder.toFrame()));
    }

    private void writeGen(Layer element, String type, FrameBuilder builder) {
        Template template = this.genTemplate(element);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        File file = CodeGenerationHelper.displayFile(this.gen(), newDisplay, type, this.target);
        if (file.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), element, newDisplay, new Engine(template).addAll(Formatters.all).render((Object)builder.toFrame()));
    }

    private void writeLayout(Layer element, String type, FrameBuilder builder) {
        builder.add("res");
        Template template = this.resTemplate(element);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        File file = CodeGenerationHelper.displayFile(this.res(), newDisplay, type, Target.AndroidResource);
        if (this.hasAbstractClass(element) && file.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.res(), type, Target.AndroidResource), element, newDisplay, new Engine(template).addAll(Formatters.all).render((Object)builder.toFrame()), Target.AndroidResource);
    }

    private void writeShared(Layer element, String type, FrameBuilder builder) {
        if (!this.hasAbstractClass(element)) {
            return;
        }
        builder.add("interface");
        Template template = this.srcTemplate(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        this.writeFrame(CodeGenerationHelper.displayFolder(this.src(Target.MobileShared), type, Target.MobileShared), element, newDisplay, new Engine(template).addAll(Formatters.all).render((Object)builder.toFrame()), Target.MobileShared);
    }

    public Template srcTemplate(Layer layer, FrameBuilder builder) {
        if (this.isAccessible(builder) || !ElementHelper.isRoot(layer)) {
            return null;
        }
        return Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new DisplaySkeletonTemplate()});
    }

    public Template genTemplate(Layer layer) {
        return layer.i$(Template.Desktop.class) ? Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new AbstractDesktopSkeletonTemplate()}) : Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new AbstractDisplaySkeletonTemplate()});
    }

    public Template resTemplate(Layer layer) {
        return layer.i$(Template.Desktop.class) ? Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new AbstractDesktopSkeletonTemplate()}) : Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new AbstractDisplaySkeletonTemplate()});
    }

    public Template pushRequesterTemplate(PassiveView element, FrameBuilder builder) {
        return null;
    }
}

