/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor;

import io.intino.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ArtifactoryConnector {
    private final List<Configuration.Repository> repositories;

    public ArtifactoryConnector(Configuration.Repository repository) {
        this(List.of(repository));
    }

    public ArtifactoryConnector(List<Configuration.Repository> repositories) {
        this.repositories = new ArrayList<Configuration.Repository>(repositories);
        this.repositories.add((Configuration.Repository)this.mavenRepository());
        this.repositories.add(0, this.intinoRepository());
    }

    public List<String> versions(String artifact) {
        try {
            for (Configuration.Repository repo : this.repositories) {
                String spec = repo.url() + (repo.url().endsWith("/") ? "" : "/") + artifact.replace(":", "/").replace(".", "/") + "/maven-metadata.xml";
                URL url = new URL(spec);
                String mavenMetadata = this.read(this.connect(repo.identifier(), url));
                if (mavenMetadata.isEmpty()) continue;
                return this.extractVersions(mavenMetadata);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private Configuration.Repository.Release mavenRepository() {
        return ArtifactoryConnector.repository("maven2", "https://repo.maven.apache.org/maven2/");
    }

    private Configuration.Repository intinoRepository() {
        return ArtifactoryConnector.repository("intino-maven", "https://artifactory.intino.io/artifactory/releases");
    }

    private InputStream connect(String mavenId, URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            return this.connect(url);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private InputStream connect(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            return connection.getInputStream();
        }
        catch (Throwable e) {
            return InputStream.nullInputStream();
        }
    }

    private List<String> extractLanguages(String result) {
        if (result == null || !result.contains("<pre><a")) {
            return Collections.emptyList();
        }
        result = result.substring(result.indexOf("<pre><a"), result.lastIndexOf("</pre"));
        ArrayList<String> languages = new ArrayList<String>(Arrays.asList(result.split("\n")));
        languages.remove(0);
        return languages.stream().map(l -> l.substring(l.indexOf("\">") + 2, l.indexOf("/<"))).toList();
    }

    private List<String> extractVersions(String metadata) {
        if (!metadata.contains("<versions>")) {
            return Collections.emptyList();
        }
        metadata = metadata.substring(metadata.indexOf("<versions>")).substring("<versions>".length() + 1);
        metadata = metadata.substring(0, metadata.indexOf("</versions>"));
        metadata = metadata.replace("<version>", "").replace("</version>", "");
        return Arrays.stream(metadata.trim().split("\n")).map(String::trim).toList();
    }

    private String read(InputStream stream) throws Throwable {
        if (stream == null) {
            return "";
        }
        byte[] bytes = stream.readAllBytes();
        stream.close();
        return new String(bytes);
    }

    public static Configuration.Repository.Release repository(final String identifier, final String url) {
        return new Configuration.Repository.Release(){

            public Configuration root() {
                return null;
            }

            public Configuration.ConfigurationNode owner() {
                return null;
            }

            public String identifier() {
                return identifier;
            }

            public String url() {
                return url;
            }

            public String user() {
                return null;
            }

            public String password() {
                return null;
            }

            public Configuration.Repository.UpdatePolicy updatePolicy() {
                return Configuration.Repository.UpdatePolicy.Daily;
            }
        };
    }
}

