package io.intino.konos.builder.codegeneration.facts;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class ColumnsTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(all(allTypes("column"), trigger("tostring"))).output(literal("+ \", ")).output(placeholder("name")).output(literal("=\" + ")).output(placeholder("name")).output(literal("()")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("id")), trigger("getter"))).output(literal("public long ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.getAlignedLong(0);\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("long", "unsigned")), trigger("getter"))).output(literal("public long ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("ULong")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("long")), trigger("getter"))).output(literal("public long ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("Long")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("int", "unsigned")), trigger("getter"))).output(literal("public long ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("UInteger")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("int")), trigger("getter"))).output(literal("public int ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("Integer")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("short", "unsigned")), trigger("getter"))).output(literal("public int ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("UShort")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("short")), trigger("getter"))).output(literal("public short ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("Short")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("byte", "unsigned")), trigger("getter"))).output(literal("public short ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("UByte")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("byte")), trigger("getter"))).output(literal("public byte ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("Byte")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("column", "boolean"), trigger("getter"))).output(literal("public boolean ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.getBoolean(")).output(placeholder("offset")).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("column", "float"), trigger("getter"))).output(literal("public float ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("Real")).output(placeholder("size")).output(literal("Bits(")).output(placeholder("offset")).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("column", "double"), trigger("getter"))).output(literal("public double ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.get")).output(placeholder("aligned")).output(literal("Real")).output(placeholder("size")).output(literal("Bits(")).output(placeholder("offset")).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("column", "datetime"), trigger("getter"))).output(literal("public ")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn java.time.Instant.ofEpochMilli(bitBuffer.get")).output(placeholder("aligned")).output(literal("Long")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal("));\n}")));
		rules.add(rule().condition(all(allTypes("column", "date"), trigger("getter"))).output(literal("public ")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn java.time.LocalDate.ofEpochDay(Short.toUnsignedInt(bitBuffer.get")).output(placeholder("aligned")).output(literal("Short")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(")));\n}")));
		rules.add(rule().condition(all(allTypes("column", "categorical"), trigger("getter"))).output(literal("public ")).output(placeholder("type", "firstUpperCase")).output(literal(".Component ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(placeholder("type", "firstUpperCase")).output(literal(".component((int)bitBuffer.getUIntegerNBits(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("bits")).output(literal("));\n}")));
		rules.add(rule().condition(all(all(allTypes("column", "real"), attribute("size", "32")), trigger("getter"))).output(literal("public float ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.getAlignedReal")).output(placeholder("size")).output(literal("Bits(")).output(placeholder("offset")).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("column", "real"), trigger("getter"))).output(literal("public double ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.getAlignedReal")).output(placeholder("size")).output(literal("Bits(")).output(placeholder("offset")).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("virtualColumn", "primitive"), trigger("abstract"))).output(literal("public abstract ")).output(placeholder("type", "firstLowerCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("();")));
		rules.add(rule().condition(all(allTypes("virtualColumn"), trigger("abstract"))).output(literal("public abstract ")).output(placeholder("type", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("();")));
		rules.add(rule().condition(all(allTypes("virtualColumn", "primitive"), trigger("implementation"))).output(literal("@Override\npublic ")).output(placeholder("type", "firstLowerCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\t// TODO: compute and return ")).output(placeholder("name", "firstLowerCase")).output(literal(".\n\treturn ")).output(placeholder("defaultValue")).output(literal(";\n}")));
		rules.add(rule().condition(all(allTypes("virtualColumn"), trigger("implementation"))).output(literal("@Override\npublic ")).output(placeholder("type", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\t// TODO: compute and return ")).output(placeholder("name", "firstLowerCase")).output(literal(".\n\treturn ")).output(placeholder("defaultValue")).output(literal(";\n}")));
		rules.add(rule().condition(all(allTypes("column", "byte", "unsigned"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(byte ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("UByte")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "byte"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(byte ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Byte")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "short", "unsigned"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(short ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("UShort")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "short"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(short ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Short")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("int", "unsigned")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(int ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("UInteger")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "int"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(int ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Integer")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "boolean"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(boolean ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.setBoolean(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("id")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(long ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.setAlignedLong(0, ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("long", "unsigned")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(long ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("ULong")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("long")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(long ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Long")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "datetime"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Long")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(".toEpochMilli());\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "date"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Short")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", (short) ")).output(placeholder("name", "firstLowerCase")).output(literal(".toEpochDay());\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column", "integer"), allTypes("unsigned")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(int ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("UInteger")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "integer"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(int ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Integer")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "boolean"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(boolean ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.setBoolean(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "float"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(float ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Real")).output(placeholder("size")).output(literal("Bits(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "double"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Real")).output(placeholder("size")).output(literal("Bits(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("longInteger", "unsigned")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(long ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("ULong")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("longInteger")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(long ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Long")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(all(allTypes("column"), allTypes("id")), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(long ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.setAlignedLong(0, ")).output(placeholder("name", "firstLowerCase")).output(literal(");\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "datetime"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Long")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(".toEpochMilli());\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "date"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal("Builder ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("type")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.set")).output(placeholder("aligned")).output(literal("Short")).output(expression().output(placeholder("bits", "nbits"))).output(literal("(")).output(placeholder("offset")).output(expression().output(literal(", ")).output(placeholder("bits"))).output(literal(", (short) ")).output(placeholder("name", "firstLowerCase")).output(literal(".toEpochDay());\n\treturn this;\n}")));
		rules.add(rule().condition(all(allTypes("column", "id"), trigger("getter"))).output(literal("public long ")).output(placeholder("name", "firstLowerCase")).output(literal("() {\n\treturn bitBuffer.getAlignedLong(0);\n}")));
		rules.add(rule().condition(all(allTypes("column", "categorical"), trigger("setter"))).output(literal("public ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(String ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.setUIntegerNBits(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("bits")).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(" == null ? (int) NULL : ")).output(placeholder("type", "firstUpperCase")).output(literal(".component(")).output(placeholder("name", "firstLowerCase")).output(literal(").index());\n\treturn this;\n}\n\npublic ")).output(placeholder("owner", "firstUpperCase")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("type", "firstUpperCase")).output(literal(".Component ")).output(placeholder("name", "firstLowerCase")).output(literal(") {\n\tbitBuffer.setUIntegerNBits(")).output(placeholder("offset")).output(literal(", ")).output(placeholder("bits")).output(literal(", ")).output(placeholder("name", "firstLowerCase")).output(literal(" == null ? (int) NULL : ")).output(placeholder("name", "firstLowerCase")).output(literal(".index());\n\treturn this;\n}")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}