package io.intino.konos.builder.codegeneration.accessor.ui.android.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class SchemaTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("root")).output(literal("package ")).output(placeholder("package", "ValidPackage")).output(literal(";\n\nimport ")).output(placeholder("root")).output(literal(".*;\nimport kotlinx.serialization.Serializable\n\n@Serializable\n")).output(placeholder("schema")));
		rules.add(rule().condition(trigger("schema")).output(expression().output(placeholder("inner"))).output(literal("\nopen class ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(expression().output(literal(": ")).output(placeholder("parent")).output(literal("()"))).output(literal(" {\n\n\t")).output(placeholder("attribute", "declaration").multiple("\n")).output(literal("\n\n\t")).output(placeholder("attribute", "getter").multiple("\n\n")).output(literal("\n\n\t")).output(placeholder("attribute", "setter").multiple("\n\n")).output(literal("\n\n    companion object {\n        fun empty(): ")).output(placeholder("name", "firstUpperCase")).output(literal(" {\n            val result = ")).output(placeholder("name", "firstUpperCase")).output(literal("()\n\t        ")).output(placeholder("attribute", "init").multiple("\n\n")).output(literal("\n            return result\n        }\n    }\n\n\t")).output(expression().output(placeholder("schema").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("word", "single"), trigger("declaration"))).output(literal("private lateinit var ")).output(placeholder("name", "FirstLowerCase")).output(literal(" : ")).output(placeholder("type", "FirstUpperCase")).output(literal("\n\nenum class ")).output(placeholder("name", "FirstUpperCase")).output(literal(" {\n\t")).output(placeholder("words").multiple(", ")).output(literal("\n}\n")));
		rules.add(rule().condition(all(allTypes("word", "multiple"), trigger("declaration"))).output(literal("private var ")).output(placeholder("name", "FirstLowerCase")).output(literal(" : List<")).output(placeholder("type", "FirstUpperCase")).output(literal("> = arrayListOf()\n\nenum class ")).output(placeholder("name", "FirstUpperCase")).output(literal(" {\n\t")).output(placeholder("words").multiple(", ")).output(literal("\n}\n")));
		rules.add(rule().condition(all(allTypes("primitive", "single"), trigger("declaration"))).output(literal("private")).output(expression().output(literal(" ")).output(placeholder("lateInit")).output(literal("lateinit"))).output(literal(" var ")).output(placeholder("name", "firstLowerCase")).output(literal(" : ")).output(placeholder("typeFrame")).output(expression().output(literal(" = ")).output(placeholder("defaultValue"))));
		rules.add(rule().condition(all(all(not(allTypes("primitive")), allTypes("single")), trigger("declaration"))).output(literal("private")).output(expression().output(literal(" ")).output(placeholder("lateInit")).output(literal("lateinit"))).output(literal(" var ")).output(placeholder("name", "firstLowerCase")).output(literal(" : ")).output(placeholder("type", "firstUpperCase")).output(expression().output(literal(" = ")).output(placeholder("defaultValue"))));
		rules.add(rule().condition(all(allTypes("map"), trigger("declaration"))).output(literal("private var ")).output(placeholder("name", "firstLowerCase")).output(literal(" : Map<")).output(placeholder("key", "renderMapType")).output(literal(", ")).output(placeholder("value", "renderMapType")).output(literal("> = mapOf()")));
		rules.add(rule().condition(all(all(allTypes("multiple"), any(allTypes("object"), allTypes("schema"))), trigger("declaration"))).output(literal("private var ")).output(placeholder("name", "firstLowerCase")).output(literal(" : List<")).output(placeholder("type", "firstUpperCase")).output(literal("> = arrayListOf()")));
		rules.add(rule().condition(all(allTypes("multiple"), trigger("declaration"))).output(literal("private var ")).output(placeholder("name", "firstLowerCase")).output(literal(" : List<")).output(placeholder("type")).output(literal("> = arrayListOf()")));
		rules.add(rule().condition(all(allTypes("word", "single"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("() : ")).output(placeholder("type", "FirstUpperCase")).output(literal(" {\n\treturn ")).output(placeholder("name", "FirstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("word", "multiple"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("() : List<")).output(placeholder("type", "FirstUpperCase")).output(literal("> {\n\treturn ")).output(placeholder("name", "FirstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("primitive", "single"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("() : ")).output(placeholder("typeFrame")).output(literal(" {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(all(not(allTypes("primitive")), allTypes("single")), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("() : ")).output(placeholder("type", "firstUpperCase")).output(literal(" {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("multiple", "schema"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("List() : List<")).output(placeholder("type", "firstUpperCase")).output(literal("> {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal("\n}\n\nfun ")).output(placeholder("name", "firstLowerCase")).output(literal("List(predicate : java.util.function.Predicate<")).output(placeholder("type", "firstUpperCase")).output(literal(">) : List<")).output(placeholder("type", "firstUpperCase")).output(literal("> {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal(".stream().filter(predicate).toList()\n}\n\nfun ")).output(placeholder("name", "firstLowerCase")).output(literal("(predicate : java.util.function.Predicate<")).output(placeholder("type", "firstUpperCase")).output(literal(">) : ")).output(placeholder("type", "firstUpperCase")).output(literal(" {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal(".stream().filter(predicate).findFirst().orElse(null)\n}")));
		rules.add(rule().condition(all(allTypes("multiple", "object"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("() : List<")).output(placeholder("type", "firstUpperCase")).output(literal("> {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("multiple"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("() : List<")).output(placeholder("type")).output(literal("> {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("map"), trigger("getter"))).output(literal("fun ")).output(placeholder("name", "firstLowerCase")).output(literal("() : Map<")).output(placeholder("key", "renderMapType")).output(literal(", ")).output(placeholder("value", "renderMapType")).output(literal("> {\n\treturn this.")).output(placeholder("name", "firstLowerCase")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("map"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("name", "firstLowerCase")).output(literal(" : Map<")).output(placeholder("key", "renderMapType")).output(literal(", ")).output(placeholder("value", "renderMapType")).output(literal(">) : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "firstLowerCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("list"), trigger("rendermaptype"))).output(literal("List<")).output(placeholder("type", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(trigger("rendermaptype")).output(placeholder("type", "firstUpperCase")));
		rules.add(rule().condition(all(allTypes("word", "single"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("(")).output(placeholder("name", "CamelCase")).output(literal(" : ")).output(placeholder("type", "FirstUpperCase")).output(literal(") : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("word", "multiple"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("(")).output(placeholder("name", "CamelCase")).output(literal(" : List<")).output(placeholder("type", "FirstUpperCase")).output(literal(">) : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("primitive", "single"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("(")).output(placeholder("name", "CamelCase")).output(literal(" : ")).output(placeholder("typeFrame")).output(literal(") : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(all(not(allTypes("primitive")), allTypes("single")), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("(")).output(placeholder("name", "CamelCase")).output(literal(" : ")).output(placeholder("type", "firstUpperCase")).output(literal(") : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal(";\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("multiple", "object"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "firstLowerCase")).output(literal("(")).output(placeholder("name", "CamelCase")).output(literal(" : List<")).output(placeholder("type", "firstUpperCase")).output(literal(">) : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("multiple", "schema"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("List(")).output(placeholder("name", "CamelCase")).output(literal(" : List<")).output(placeholder("type", "firstUpperCase")).output(literal(">) : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("multiple"), trigger("setter"))).output(literal("fun ")).output(placeholder("name", "CamelCase")).output(literal("(")).output(placeholder("name", "CamelCase")).output(literal(" : List<")).output(placeholder("type")).output(literal(">) : ")).output(placeholder("element", "firstUpperCase")).output(literal(" {\n\tthis.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("name", "CamelCase")).output(literal("\n\treturn this\n}")));
		rules.add(rule().condition(all(allTypes("multiple"), trigger("init"))).output(literal("result.")).output(placeholder("name", "firstLowerCase")).output(literal(" = emptyList();")));
		rules.add(rule().condition(all(allTypes("single", "object"), trigger("init"))).output(literal("result.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("type", "PascalCase")).output(literal(".empty()")));
		rules.add(rule().condition(all(allTypes("single"), trigger("init"))).output(literal("result.")).output(placeholder("name", "firstLowerCase")).output(literal(" = ")).output(placeholder("typeFrame", "empty")));
		rules.add(rule().condition(all(allTypes("typeFrame", "datetime"), trigger("empty"))).output(literal("null!!")));
		rules.add(rule().condition(all(allTypes("typeFrame", "date"), trigger("empty"))).output(literal("null!!")));
		rules.add(rule().condition(all(allTypes("typeFrame", "real"), trigger("empty"))).output(literal("null!!")));
		rules.add(rule().condition(all(allTypes("typeFrame", "boolean"), trigger("empty"))).output(literal("false")));
		rules.add(rule().condition(all(allTypes("typeFrame", "integer"), trigger("empty"))).output(literal("null!!")));
		rules.add(rule().condition(all(allTypes("typeFrame", "longinteger"), trigger("empty"))).output(literal("null!!")));
		rules.add(rule().condition(all(allTypes("typeFrame", "word"), trigger("empty"))).output(literal("null!!")));
		rules.add(rule().condition(all(allTypes("typeFrame"), trigger("empty"))).output(literal("\"\"")));
		rules.add(rule().condition(allTypes("typeFrame", "datetime")).output(literal("kotlinx.datetime.Instant")));
		rules.add(rule().condition(allTypes("typeFrame", "date")).output(literal("kotlinx.datetime.Instant")));
		rules.add(rule().condition(allTypes("typeFrame", "real")).output(literal("Double")));
		rules.add(rule().condition(allTypes("typeFrame", "integer")).output(literal("Int")));
		rules.add(rule().condition(allTypes("typeFrame", "longinteger")).output(literal("Long")));
		rules.add(rule().condition(allTypes("typeFrame")).output(placeholder("value")));
		rules.add(rule().condition(trigger("inner")).output(literal("@kotlinx.serialization.Serializable")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}