package io.intino.konos.builder.codegeneration.accessor.ui.android.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.allTypes;
import static io.intino.itrules.template.outputs.Outputs.*;

public class AppTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("manifest")).output(literal("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\">\n\n    <uses-permission android:name=\"android.permission.INTERNET\" />\n    <uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\" />\n    <uses-permission android:name=\"android.permission.READ_EXTERNAL_STORAGE\" />\n    <uses-permission android:name=\"com.google.android.providers.gsf.permission.READ_GSERVICES\"/>\n\n    <application\n        android:label=\"@string/app_name\"\n        android:allowBackup=\"false\"\n        android:supportsRtl=\"true\"\n        android:theme=\"@style/AppTheme\"\n        android:usesCleartextTraffic=\"true\"\n        android:requestLegacyExternalStorage=\"true\">\n\n        ")).output(placeholder("resource").multiple("\n")).output(literal("\n\n        <provider\n            android:name=\"androidx.core.content.FileProvider\"\n            android:authorities=\"${applicationId}.provider\"\n            android:exported=\"false\"\n            android:grantUriPermissions=\"true\">\n            <meta-data\n                android:name=\"android.support.FILE_PROVIDER_PATHS\"\n                android:resource=\"@xml/provider_paths\" />\n        </provider>\n    </application>\n\n</manifest>")));
		rules.add(rule().condition(allTypes("resource", "main")).output(literal("<activity\n    android:name=\".pages.")).output(placeholder("name", "PascalCase")).output(literal("Activity\"\n    android:exported=\"true\"\n    android:windowSoftInputMode=\"adjustNothing\">\n    <intent-filter>\n        <action android:name=\"android.intent.action.MAIN\" />\n        <category android:name=\"android.intent.category.LAUNCHER\" />\n    </intent-filter>\n</activity>")));
		rules.add(rule().condition(allTypes("resource")).output(literal("<activity\n    android:name=\".pages.")).output(placeholder("name", "PascalCase")).output(literal("Activity\"\n    android:exported=\"true\"\n    android:windowSoftInputMode=\"adjustNothing\">\n</activity>")));
		rules.add(rule().condition(allTypes("gradle", "settings")).output(literal("pluginManagement {\n    repositories {\n        google()\n        gradlePluginPortal()\n        mavenCentral()\n    }\n}\n\ndependencyResolutionManagement {\n    repositories {\n        google()\n        mavenCentral()\n    }\n}\n\nrootProject.name = \"")).output(placeholder("project")).output(literal("\"\ninclude(\":android\")\ninclude(\":shared\")")));
		rules.add(rule().condition(allTypes("gradle", "android")).output(literal("plugins {\n    id(\"com.android.application\")\n    kotlin(\"android\")\n}\n\nandroid {\n    namespace = \"")).output(placeholder("package")).output(literal(".mobile.android\"\n    compileSdk = 34\n    defaultConfig {\n        applicationId = \"")).output(placeholder("package")).output(literal(".mobile.android\"\n        minSdk = 32\n        targetSdk = 34\n        versionCode = 1\n        versionName = \"1.0\"\n    }\n    buildFeatures {\n        compose = true\n    }\n    composeOptions {\n        kotlinCompilerExtensionVersion = \"1.4.4\"\n    }\n    packagingOptions {\n        resources {\n            excludes += \"/META-INF/{AL2.0,LGPL2.1}\"\n        }\n    }\n    buildTypes {\n        getByName(\"release\") {\n            isMinifyEnabled = false\n        }\n    }\n    compileOptions {\n        sourceCompatibility = JavaVersion.VERSION_18\n        targetCompatibility = JavaVersion.VERSION_18\n    }\n}\n\ndependencies {\n    implementation(project(\":shared\"))\n    implementation(\"androidx.compose.ui:ui:1.5.4\")\n    implementation(\"androidx.compose.ui:ui-tooling:1.5.4\")\n    implementation(\"androidx.compose.ui:ui-tooling-preview:1.5.4\")\n    implementation(\"androidx.compose.foundation:foundation:1.5.4\")\n    implementation(\"androidx.compose.material:material:1.5.4\")\n    implementation(\"androidx.activity:activity-compose:1.8.2\")\n    implementation(\"com.google.android.material:material:1.11.0\")\n    implementation(\"com.google.android.flexbox:flexbox:3.0.0\")\n    implementation(\"org.jetbrains.kotlinx:kotlinx-datetime:0.4.1\")\n    implementation(\"org.jetbrains.kotlinx:kotlinx-datetime:0.4.1\")\n    implementation(\"androidx.databinding:databinding-runtime:8.2.0\")\n    implementation(\"com.caverock:androidsvg-aar:1.4\")\n    implementation(\"com.squareup.okhttp3:okhttp:4.9.0\")\n    implementation(\"com.google.android.gms:play-services-maps:18.2.0\")\n    implementation(\"com.malinskiy:materialicons:1.0.3\")\n}")));
		rules.add(rule().condition(allTypes("gradle", "shared")).output(literal("plugins {\n    kotlin(\"multiplatform\")\n    id(\"org.jetbrains.kotlin.plugin.serialization\")\n    id(\"com.android.library\")\n}\n\nkotlin {\n    android()\n\n    listOf(\n        iosX64(),\n        iosArm64(),\n        iosSimulatorArm64()\n    ).forEach {\n        it.binaries.framework {\n            baseName = \"shared\"\n        }\n    }\n\n    sourceSets {\n        val commonMain by getting {\n            dependencies {\n                implementation(\"org.jetbrains.kotlinx:kotlinx-serialization-json:1.4.1\")\n                implementation(\"org.jetbrains.kotlinx:kotlinx-coroutines-core:1.6.4\")\n                implementation(\"org.jetbrains.kotlin:kotlin-stdlib:1.8.22\")\n                implementation(\"org.jetbrains.kotlinx:kotlinx-datetime:0.4.1\")\n            }\n        }\n        val commonTest by getting {\n            dependencies {\n                implementation(kotlin(\"test\"))\n            }\n        }\n        val androidMain by getting {\n            dependencies {\n                implementation(\"com.google.android.material:material:1.11.0\")\n                implementation(\"com.google.android.flexbox:flexbox:3.0.0\")\n                implementation(\"com.squareup.okhttp3:okhttp:4.9.0\")\n                implementation(\"com.android.volley:volley:1.2.1\")\n            }\n        }\n        val androidTest by getting\n        val iosX64Main by getting\n        val iosArm64Main by getting\n        val iosSimulatorArm64Main by getting\n        val iosMain by creating {\n            dependsOn(commonMain)\n            iosX64Main.dependsOn(this)\n            iosArm64Main.dependsOn(this)\n            iosSimulatorArm64Main.dependsOn(this)\n        }\n        val iosX64Test by getting\n        val iosArm64Test by getting\n        val iosSimulatorArm64Test by getting\n        val iosTest by creating {\n            dependsOn(commonTest)\n            iosX64Test.dependsOn(this)\n            iosArm64Test.dependsOn(this)\n            iosSimulatorArm64Test.dependsOn(this)\n        }\n    }\n}\n\nandroid {\n    namespace = \"")).output(placeholder("package")).output(literal(".mobile\"\n    compileSdk = 34\n    defaultConfig {\n        minSdk = 32\n        targetSdk = 34\n    }\n    compileOptions {\n        sourceCompatibility = JavaVersion.VERSION_18\n        targetCompatibility = JavaVersion.VERSION_18\n    }\n}")));
		rules.add(rule().condition(allTypes("properties")).output(literal("<resources>\n    ")).output(placeholder("component").multiple("\n")).output(literal("\n</resources>")));
		rules.add(rule().condition(allTypes("strings")).output(literal("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <string name=\"app_name\">")).output(placeholder("project")).output(literal("</string>\n</resources>")));
		rules.add(rule().condition(allTypes("component")).output(literal("<declare-styleable name=\"")).output(placeholder("name", "firstUpperCase")).output(literal("\"")).output(expression().output(literal(" parent=\"")).output(placeholder("parent", "firstUpperCase")).output(literal("\""))).output(literal(">\n    ")).output(placeholder("attribute").multiple("\n")).output(literal("\n</declare-styleable>")));
		rules.add(rule().condition(allTypes("attribute", "root")).output(literal("<attr name=\"")).output(placeholder("name", "lowerCase")).output(literal("\" format=\"string\" />")));
		rules.add(rule().condition(allTypes("attribute")).output(literal("<attr name=\"")).output(placeholder("component", "camelCaseToUnderscoreCase", "lowerCase")).output(literal("_")).output(placeholder("name", "lowerCase")).output(literal("\" format=\"string\" />")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}