/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.helpers;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.dsl.CatalogComponents;
import io.intino.konos.dsl.HelperComponents;
import io.intino.konos.dsl.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;

public class CodeGenerationHelper {
    public static final String UI = "ui";
    public static final String Displays = "%sdisplays";
    public static final String DisplaysType = "%sdisplays/%ss";
    public static final String Notifiers = "%sdisplays/notifiers";
    public static final String Requesters = "%sdisplays/requesters";
    public static final String Resources = "%sresources";
    public static final String Pages = "%spages";

    public static boolean hasAbstractClass(Layer element, Target target) {
        if (target == Target.Server) {
            return true;
        }
        return !element.i$(ElementHelper.conceptOf(Template.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) && !element.i$(ElementHelper.conceptOf(HelperComponents.Row.class));
    }

    public static boolean isScrollable(Layer element, Target target) {
        return element.i$(ElementHelper.conceptOf(Template.class)) && ((Template)element.a$(Template.class)).scrollable();
    }

    public static File folder(File root, String path, Target target) {
        return new File(root.getAbsolutePath() + CodeGenerationHelper.format(path, target));
    }

    public static File displaysFolder(File folder, Target target) {
        return new File(folder, CodeGenerationHelper.displaysPath(target));
    }

    public static File displayFolder(File folder, String type, Target target) {
        return new File(folder, CodeGenerationHelper.displayPath(folder, type, target));
    }

    public static File displayFile(File folder, String name, String type, Target target) {
        return CodeGenerationHelper.fileOf(new File(folder, CodeGenerationHelper.displayPath(folder, type, target)), name, target);
    }

    public static String displayFilename(String name) {
        return CodeGenerationHelper.displayFilename(name, "");
    }

    public static String displayFilename(String name, String suffix) {
        return StringHelper.snakeCaseToCamelCase((String)(name + suffix));
    }

    private static String displaysPath(Target target) {
        return CodeGenerationHelper.format(Displays, target);
    }

    public static String displayPath(File folder, String type, Target target) {
        if (target == Target.AndroidResource) {
            return File.separator + "layout";
        }
        return type.equalsIgnoreCase("display") || type.equalsIgnoreCase("AccessibleDisplay") ? CodeGenerationHelper.format(Displays, target) : String.format(DisplaysType, CodeGenerationHelper.uiSubPath(target), type).toLowerCase();
    }

    public static File displayRequesterFolder(File folder, Target target) {
        return new File(folder, CodeGenerationHelper.format(Requesters, target));
    }

    public static File displayNotifierFolder(File folder, Target target) {
        return new File(folder, CodeGenerationHelper.format(Notifiers, target));
    }

    public static File resourceFolder(File folder, Target target) {
        return new File(folder, CodeGenerationHelper.format(Resources, target));
    }

    public static String resourceFilename(String name) {
        return CodeGenerationHelper.resourceFilename(name, "Resource");
    }

    public static String resourceFilename(String name, String suffix) {
        return StringHelper.snakeCaseToCamelCase((String)(name + suffix));
    }

    public static File serviceFolder(File folder) {
        return new File(folder, UI);
    }

    public static String serviceFilename(String name) {
        return StringHelper.snakeCaseToCamelCase((String)(name + "Service"));
    }

    public static String format(String path, Target target) {
        return String.format(path, CodeGenerationHelper.uiSubPath(target));
    }

    public static String uiSubPath(Target target) {
        return target == Target.Server ? "ui/" : "";
    }

    public static File fileOf(File file, String name, Target target) {
        if (target == Target.Server) {
            return Commons.javaFile(file, name);
        }
        if (target == Target.Android || target == Target.MobileShared) {
            return Commons.kotlinFile(file, name);
        }
        if (target == Target.AndroidResource) {
            return Commons.xmlFile(file, name);
        }
        return Commons.javascriptFile(file, name);
    }

    public static File createIfNotExists(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

