/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.ResourceTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.PageRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Service;
import io.intino.magritte.framework.Layer;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceRenderer
extends UIRenderer {
    protected final Service.UI.Resource resource;
    protected final Target target;

    public ResourceRenderer(CompilationContext compilationContext, Service.UI.Resource resource, Target target) {
        super(compilationContext);
        this.target = target;
        this.resource = resource;
    }

    @Override
    public void render() throws KonosException {
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        FrameBuilder builder = this.buildFrame().add("resource").add("name", (Object)this.resource.name$()).add("parameter", (Object)this.parameters(this.resource));
        if (this.resource.isStaticPage()) {
            builder.add("static");
        }
        if (this.resource.isAssetPage()) {
            builder.add("asset");
        }
        if (uiService.googleApiKey() != null) {
            builder.add("googleApiKey", (Object)Formatters.customize("googleApiKey", uiService.googleApiKey()));
        }
        if (this.resource.isConfidential()) {
            builder.add("confidential", (Object)"");
        }
        builder.add("page", (Object)this.buildBaseFrame().add("page").add(this.isMobile(uiService) ? "mobile" : "no-mobile").add("name", (Object)this.resource.name$()));
        Commons.writeFrame(CodeGenerationHelper.resourceFolder(this.gen(this.target), this.target), CodeGenerationHelper.resourceFilename(this.resource.name$()), this.setup(new ResourceTemplate()).render((Object)builder.toFrame()));
        if (this.target.equals((Object)Target.Server)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(CodeGenerationHelper.resourceFolder(this.gen(this.target), this.target), CodeGenerationHelper.resourceFilename(this.resource.name$())).getAbsolutePath()));
        }
        new PageRenderer(this.context, this.resource, this.target).execute();
    }

    private FrameBuilder[] parameters(Service.UI.Resource resource) {
        Service.UI service = (Service.UI)resource.core$().ownerAs(Service.UI.class);
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        parameters.addAll(resource.parameterList().stream().map(Layer::name$).collect(Collectors.toList()));
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add(this.isMobile(service) ? "mobile" : "no-mobile").add("name", parameter).add("resource", (Object)resource.name$())).toArray(FrameBuilder[]::new);
    }
}

