/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.dsl.CatalogComponents;
import io.intino.konos.dsl.Display;
import io.intino.konos.dsl.HelperComponents;
import io.intino.konos.dsl.PassiveView;
import io.intino.konos.dsl.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public abstract class UiRendererWriter
implements RendererWriter {
    protected CompilationContext context;
    protected Target target;

    public UiRendererWriter(CompilationContext context, Target target) {
        this.context = context;
        this.target = target;
    }

    @Override
    public Target target() {
        return this.target;
    }

    protected File root() {
        return this.context.root(this.target);
    }

    protected File src() {
        return this.src(this.target);
    }

    protected File src(Target target) {
        return this.context.src(target);
    }

    protected File gen() {
        return this.context.gen(this.target);
    }

    protected File gen(Target target) {
        return this.context.gen(target);
    }

    protected File res() {
        return this.context.res(this.target);
    }

    protected String displayName(Layer element, boolean accessible) {
        String suffix;
        String string = suffix = accessible ? "Proxy" : "";
        String abstractValue = accessible ? "" : (ElementHelper.isRoot(element) && this.hasAbstractClass(element) ? "Abstract" : "");
        return CodeGenerationHelper.displayFilename(StringHelper.snakeCaseToCamelCase((String)(abstractValue + Commons.firstUpperCase(element.name$()))), suffix);
    }

    protected boolean hasAbstractClass(Layer element) {
        return CodeGenerationHelper.hasAbstractClass(element, this.target);
    }

    protected void writeFrame(File packageFolder, Layer element, String name, String text) {
        this.writeFrame(packageFolder, element, name, text, this.target);
    }

    protected void writeFrame(File packageFolder, Layer element, String name, String text, Target target) {
        try {
            packageFolder.mkdirs();
            File file = CodeGenerationHelper.fileOf(packageFolder, name, target);
            Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            if (!target.equals((Object)Target.Server)) {
                return;
            }
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(element), Commons.javaFile(packageFolder, name).getAbsolutePath()));
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getMessage());
        }
    }

    protected String nameOfPassiveViewFile(PassiveView element, Frame frame, String suffix) {
        return this.nameOfPassiveViewFile(element, this.isAccessible(frame), suffix);
    }

    protected String nameOfPassiveViewFile(PassiveView element, boolean accessible, String suffix) {
        return StringHelper.snakeCaseToCamelCase((String)(element.name$() + (accessible ? "Proxy" : "") + suffix));
    }

    protected boolean isAccessible(FrameBuilder builder) {
        return builder.is("accessible");
    }

    protected boolean isAccessible(Frame frame) {
        return frame.is("accessible");
    }

    protected boolean hasConcreteNotifier(PassiveView element) {
        if (element.i$(ElementHelper.conceptOf(Display.Accessible.class))) {
            return true;
        }
        return !element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) && !element.i$(ElementHelper.conceptOf(HelperComponents.Row.class)) && !element.i$(ElementHelper.conceptOf(Template.class));
    }

    protected boolean hasConcreteRequester(PassiveView element) {
        if (element.i$(ElementHelper.conceptOf(Display.Accessible.class))) {
            return true;
        }
        return !element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) && !element.i$(ElementHelper.conceptOf(HelperComponents.Row.class)) && !element.i$(ElementHelper.conceptOf(Template.class));
    }

    protected io.intino.itrules.Template setup(io.intino.itrules.Template template) {
        if (template == null) {
            return null;
        }
        return Formatters.customize(template);
    }
}

