/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rocketchat;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class RocketchatTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"rocketchat", "gen"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".rocketchat.*;\n\nimport io.intino.alexandria.rocketchat.Bot;\nimport java.io.IOException;\nimport java.util.Arrays;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("RocketChatBot extends Bot {\n\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("RocketChat ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat;\n\t")}).output(new Rule.Output[]{this.mark("level", new String[]{"field"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("RocketChatBot(")}).output(new Rule.Output[]{this.mark("box", new String[]{"validname", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box, String token) {\n\t\tsuper(token);\n\t\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("RocketChat(box);\n\t\t")}).output(new Rule.Output[]{this.mark("level", new String[]{"constructor"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\t\tadd(\"help\", java.util.Collections.emptyList(), java.util.Collections.emptyList(), \"Show this help\", (properties, args) -> {\n\t\t\tfinal java.util.Map<String, CommandInfo> context = this.commandsInfoByContext(contexts().get(properties.username()).command());\n\t\t\tStringBuilder builder = new StringBuilder();\n\t\t\tcontext.keySet().forEach((c) -> builder.append(formatCommand(c, context.get(c))).append(\"\\n\"));\n\t\t\treturn builder.toString();\n\t\t});\n\t\tadd(\"exit\", java.util.Collections.emptyList(), java.util.Collections.emptyList(), \"Exit from current level\", (properties, args) -> {\n\t\t\tfinal Context context = this.contexts().get(properties.username());\n\t\t\tif (context != null) {\n\t\t\t\tString command = context.command();\n\t\t\t\tfinal String message = command.isEmpty() ? \"\" : \"Exited from \" + (command.contains(\"|\") ? command.substring(command.lastIndexOf(\"|\") + 1) : command) + \" \" + String.join(\" \", Arrays.asList(context.getObjects()));\n\t\t\t\tcontext.command(command.contains(\"|\") ? command.substring(0, command.lastIndexOf(\"|\")) : \"\");\n\t\t\t\tcontext.objects(context.getObjects().length > 1 ? Arrays.copyOfRange(context.getObjects(), 0, context.getObjects().length - 1) : new String[0]);\n\t\t\t\treturn message;\n\t\t\t}\n\t\t\treturn \"\";\n\t\t});\n\t\tadd(\"where\", java.util.Collections.emptyList(), java.util.Collections.emptyList(), \"Shows the current level\", (properties, args) -> {\n\t\t\tfinal Context context = this.contexts().get(properties.username());\n\t\t\treturn context != null ? context : \"root\";\n\t\t});\n\t\t")}).output(new Rule.Output[]{this.mark("request", new String[]{"add"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\ttry {\n\t\t\tconnect();\n\t\t\tthis.")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat.init(session(), users());\n\t\t\t")}).output(new Rule.Output[]{this.mark("level", new String[]{"init"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t} catch (IOException | javax.websocket.DeploymentException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e);\n\t\t}\n\t}\n\n\tprivate static String formatCommand(String command, CommandInfo info) {\n\t\treturn \"`\" + command.substring(command.lastIndexOf(\"$\") + 1) + helpParameters(info.parameters()) + \"` \" + info.description() + \"\\n\";\n\t}\n\n\tprivate static String helpParameters(java.util.List<String> parameters) {\n\t\treturn parameters.isEmpty() ? \"\" : \" <\" + String.join(\"> <\", parameters) + \">\";\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"slack", "actions"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".slack;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("box", new String[]{"validname", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".slack.*;\nimport io.intino.alexandria.slack.Bot;\nimport io.intino.alexandria.slack.Bot.MessageProperties;\n\nimport java.util.Map;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("RocketChat {\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("box", new String[]{"validname", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase", "snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal("RocketChat(")}).output(new Rule.Output[]{this.mark("box", new String[]{"validname", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n\t\tthis.box = box;\n\t}\n\n\tpublic void init(com.ullink.slack.simpleslackapi.RocketChatSession session) {\n\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("request", new String[]{"method"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.type("level"), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("private ")}).output(new Rule.Output[]{this.mark("name", new String[]{"slashToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("RocketChat ")}).output(new Rule.Output[]{this.mark("name", new String[]{"slashToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat;")}), this.rule().condition(this.type("level"), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.mark("name", new String[]{"slashToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"slashToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("RocketChat(box);")}), this.rule().condition(this.type("level"), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.mark("name", new String[]{"slashToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat.init(session(), users());")}), this.rule().condition(this.type("request"), new Rule.Condition[]{this.trigger("add")}).output(new Rule.Output[]{this.literal("add(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"lowerCase"})}).output(new Rule.Output[]{this.literal("\", \"")}).output(new Rule.Output[]{this.mark("context", new String[]{"lowercase"})}).output(new Rule.Output[]{this.literal("\", java.util.Arrays.asList(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"name"}).multiple(", ")}).output(new Rule.Output[]{this.literal("), java.util.Arrays.asList(")}).output(new Rule.Output[]{this.mark("component", new String[0]).multiple(", ")}).output(new Rule.Output[]{this.literal("), \"")}).output(new Rule.Output[]{this.mark("description", new String[0])}).output(new Rule.Output[]{this.literal("\", (properties, args) -> ")}).output(new Rule.Output[]{this.mark("type", new String[]{"slashToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("RocketChat.")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("(properties")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"cast"}).multiple(", ")})}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.allTypes(new String[]{"request", "newMethod"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("(MessageProperties properties")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[0]).multiple(", ")})}).output(new Rule.Output[]{this.literal(") {\n\treturn \"\";\n}")}), this.rule().condition(this.type("request"), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("responseType", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("(MessageProperties properties")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[0]).multiple(", ")})}).output(new Rule.Output[]{this.literal(") {\n\treturn \"\";\n}")}), this.rule().condition(this.trigger("component"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.allTypes(new String[]{"parameter", "Boolean"}), new Rule.Condition[]{this.trigger("cast")}).output(new Rule.Output[]{this.literal("args.length > ")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal(" ? Boolean.parseBoolean(args[")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal("]) : false")}), this.rule().condition(this.allTypes(new String[]{"parameter", "Double"}), new Rule.Condition[]{this.trigger("cast")}).output(new Rule.Output[]{this.literal("args.length > ")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal(" ? Double.parseDouble(args[")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal("]) : 0")}), this.rule().condition(this.allTypes(new String[]{"parameter", "Integer"}), new Rule.Condition[]{this.trigger("cast")}).output(new Rule.Output[]{this.literal("args.length > ")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal(" ? Integer.parseInt(args[")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal("]) : 0")}), this.rule().condition(this.allTypes(new String[]{"parameter", "String", "multiple"}), new Rule.Condition[]{this.trigger("cast")}).output(new Rule.Output[]{this.literal("args")}), this.rule().condition(this.allTypes(new String[]{"parameter", "String"}), new Rule.Condition[]{this.trigger("cast")}).output(new Rule.Output[]{this.literal("args.length > ")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal(" ? args[")}).output(new Rule.Output[]{this.mark("pos", new String[0])}).output(new Rule.Output[]{this.literal("] : \"\"")}), this.rule().condition(this.allTypes(new String[]{"parameter", "multiple"}), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("[] ")}).output(new Rule.Output[]{this.mark("name", new String[0])}), this.rule().condition(this.type("parameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[0])})});
    }
}

