/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rocketchat;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.rocketchat.BotActionsUpdater;
import io.intino.konos.builder.codegeneration.services.slack.SlackTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.KonosGraph;
import io.intino.konos.dsl.Service;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RocketChatRenderer
extends Renderer {
    private final List<Service.SlackBot> services;

    public RocketChatRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.services = graph.serviceList(Service::isSlackBot).map(Service::asSlackBot).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.services.forEach(this::processService);
    }

    private void processService(Service.SlackBot service) {
        String srcName = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack";
        FrameBuilder builder = this.createFrameBuilder(service.name$(), service.requestList(), true);
        for (String level : this.collectLevels(service).keySet()) {
            builder.add("level", (Object)new FrameBuilder(new String[]{"level"}).add("name", (Object)level).toFrame());
        }
        Commons.writeFrame(this.gen(Target.Server), StringHelper.snakeCaseToCamelCase((String)service.name$()) + "SlackBot", this.template().render((Object)builder));
        if (this.alreadyRendered(new File(this.src(Target.Server), "slack"), srcName)) {
            this.updateBot(service, srcName);
        } else {
            this.newBotActions(service);
        }
    }

    private void updateBot(Service.SlackBot service, String name) {
        new BotActionsUpdater(this.context, Commons.javaFile(new File(this.src(Target.Server), "slack"), name), service.requestList()).update();
    }

    private void newBotActions(Service.SlackBot service) {
        File directory = new File(this.src(Target.Server), "slack");
        if (!this.alreadyRendered(directory, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack")) {
            Commons.writeFrame(directory, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack", this.template().render((Object)this.createFrameBuilder(service.name$(), service.requestList(), false)));
        }
        Map<String, List<Service.SlackBot.Request>> groups = this.collectLevels(service);
        for (String requestContainer : groups.keySet()) {
            this.classes().put("Service#" + service.name$(), "slack." + requestContainer + "Slack");
            if (this.alreadyRendered(directory, requestContainer + "Slack")) continue;
            Commons.writeFrame(directory, requestContainer + "Slack", this.template().render((Object)this.createFrameBuilder(requestContainer, groups.get(requestContainer), false)));
        }
    }

    private Map<String, List<Service.SlackBot.Request>> collectLevels(Service.SlackBot service) {
        return this.collect(service.requestList());
    }

    private LinkedHashMap<String, List<Service.SlackBot.Request>> collect(List<Service.SlackBot.Request> requests) {
        LinkedHashMap map = requests.stream().filter(request -> !request.requestList().isEmpty()).collect(Collectors.toMap(this::name, Service.SlackBot.Request::requestList, (a, b) -> b, LinkedHashMap::new));
        for (Service.SlackBot.Request request2 : requests) {
            map.putAll(this.collect(request2.requestList()));
        }
        return map;
    }

    private String name(Service.SlackBot.Request request) {
        String s;
        StringBuilder name = new StringBuilder();
        Service.SlackBot.Request r = request;
        while (r.i$(Service.SlackBot.Request.class)) {
            name.insert(0, Commons.firstUpperCase(r.name$()) + "|");
            if (!r.core$().owner().is(Service.SlackBot.Request.class)) break;
            r = (Service.SlackBot.Request)r.core$().ownerAs(Service.SlackBot.Request.class);
        }
        return (s = name.toString()).endsWith("|") ? s.substring(0, s.length() - 1) : s;
    }

    private FrameBuilder createFrameBuilder(String name, List<Service.SlackBot.Request> requests, boolean gen) {
        FrameBuilder builder = new FrameBuilder(new String[]{"slack", gen ? "gen" : "actions"});
        builder.add("package", (Object)this.packageName()).add("name", (Object)name).add("box", (Object)this.boxName());
        if (gen) {
            this.allRequests(requests, builder);
        } else {
            this.createRequests(requests, builder);
        }
        return builder;
    }

    private void allRequests(List<Service.SlackBot.Request> requests, FrameBuilder builder) {
        for (Service.SlackBot.Request request : requests) {
            builder.add("request", (Object)this.createRequestFrame(request));
            this.allRequests(request.requestList(), builder);
        }
    }

    private void createRequests(List<Service.SlackBot.Request> requests, FrameBuilder builder) {
        for (Service.SlackBot.Request request : requests) {
            builder.add("request", (Object)this.createRequestFrame(request));
        }
    }

    private Frame createRequestFrame(Service.SlackBot.Request request) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("type", (Object)(request.core$().owner().is(Service.SlackBot.Request.class) ? this.name((Service.SlackBot.Request)request.core$().ownerAs(Service.SlackBot.Request.class)) : request.core$().owner().name())).add("box", (Object)this.boxName()).add("name", (Object)request.name$()).add("description", (Object)request.description());
        if (request.core$().owner().is(Service.SlackBot.Request.class)) {
            builder.add("context", (Object)this.name((Service.SlackBot.Request)request.core$().ownerAs(Service.SlackBot.Request.class)));
        }
        builder.add("responseType", (Object)(request.responseType().equals((Object)Service.SlackBot.Request.ResponseType.Text) ? "String" : "SlackAttachment"));
        List<Service.SlackBot.Request.Parameter> parameters = request.parameterList();
        for (int i = 0; i < parameters.size(); ++i) {
            builder.add("parameter", (Object)new FrameBuilder(new String[]{"parameter", parameters.get(i).type().name(), parameters.get(i).multiple() ? "multiple" : "single"}).add("type", (Object)parameters.get(i).type().name()).add("name", (Object)parameters.get(i).name$()).add("pos", (Object)i).toFrame());
        }
        for (Service.SlackBot.Request component : request.requestList()) {
            builder.add("component", (Object)component.name$());
        }
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new SlackTemplate()).add("slashToCamelCase", o -> StringHelper.snakeCaseToCamelCase((String)o.toString().replace("|", "_")));
    }

    private boolean alreadyRendered(File destiny, String name) {
        return Commons.javaFile(destiny, name).exists();
    }
}

