/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.messaging;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.action.MessagingRequestActionRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingRequestTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.KonosGraph;
import io.intino.konos.dsl.Parameter;
import io.intino.konos.dsl.Response;
import io.intino.konos.dsl.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class MessagingRequestRenderer
extends Renderer {
    private static final String REQUESTS = "requests";
    private final List<Service.Messaging> services;

    public MessagingRequestRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.services = graph.serviceList(Service::isMessaging).map(Service::asMessaging).collect(Collectors.toList());
    }

    @Override
    public void render() throws KonosException {
        for (Service.Messaging service : this.services) {
            this.processService(service);
        }
    }

    private void processService(Service.Messaging service) throws KonosException {
        for (Service.Messaging.Request request : service.core$().findNode(Service.Messaging.Request.class)) {
            this.processRequest(request);
        }
    }

    private void processRequest(Service.Messaging.Request request) throws KonosException {
        File packageFolder = new File(this.gen(Target.Server), REQUESTS);
        Commons.writeFrame(packageFolder, StringHelper.snakeCaseToCamelCase((String)request.name$()) + "Request", this.template().render((Object)this.fillRequestFrame(request)));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(request), Commons.javaFile(packageFolder, StringHelper.snakeCaseToCamelCase((String)request.name$()) + "Request").getAbsolutePath()));
        this.createCorrespondingAction(request);
    }

    private void createCorrespondingAction(Service.Messaging.Request request) throws KonosException {
        new MessagingRequestActionRenderer(this.context, request).execute();
    }

    private Frame fillRequestFrame(Service.Messaging.Request request) {
        String returnType = Commons.returnType(request.response());
        Frame parameter = this.parameterFrame(request.parameter());
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("call", (Object)this.call(returnType, parameter));
        if (parameter != null) {
            builder.add("parameter", (Object)parameter);
        }
        if (!returnType.equals("void")) {
            builder.add("returnType", (Object)returnType).add("returnMessageType", (Object)this.messageType(request.response()));
        }
        if (!request.exceptionList().isEmpty()) {
            builder.add("exception", (Object)"");
        }
        if (!request.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        return builder.toFrame();
    }

    private Frame call(String returnType, Frame parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{returnType, "call"});
        if (parameter != null) {
            builder.add("parameter", (Object)parameter);
        }
        return builder.toFrame();
    }

    private String messageType(Response response) {
        return response.isFile() ? "Bytes" : "Text";
    }

    private Frame parameterFrame(Parameter parameter) {
        if (parameter == null) {
            return null;
        }
        return new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Template template() {
        return Formatters.customize(new MessagingRequestTemplate());
    }
}

