/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.cli;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.cli.CliActionTemplate;
import io.intino.konos.builder.codegeneration.services.cli.CliCommandTemplate;
import io.intino.konos.builder.codegeneration.services.cli.CliTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.KonosGraph;
import io.intino.konos.dsl.Parameter;
import io.intino.konos.dsl.Service;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CliRenderer
extends Renderer {
    private final List<Service.CLI> services;

    public CliRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.services = graph.serviceList(Service::isCLI).map(Service::asCLI).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.services.forEach(this::processService);
    }

    private void processService(Service.CLI service) {
        this.writeService(service);
        this.writeAuthenticator(service);
        this.writeCli(service);
        this.writeCommands(service);
    }

    private void writeService(Service.CLI service) {
        FrameBuilder builder = this.buildFrame(service).add("service");
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Service";
        Commons.writeFrame(this.gen(Target.Server), className, this.template().render((Object)builder));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.gen(Target.Server), className).getAbsolutePath()));
    }

    private void writeAuthenticator(Service.CLI service) {
        FrameBuilder builder = this.buildFrame(service).add("authenticator");
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "ServiceAuthenticator";
        File srcFile = Commons.javaFile(this.src(Target.Server), className);
        if (srcFile.exists()) {
            return;
        }
        Commons.writeFrame(this.src(Target.Server), className, this.template().render((Object)builder));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.src(Target.Server), className).getAbsolutePath()));
    }

    private void writeCli(Service.CLI service) {
        FrameBuilder builder = this.buildFrame(service);
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$());
        Commons.writeFrame(this.gen(Target.Server), className, this.template().render((Object)builder));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.gen(Target.Server), className).getAbsolutePath()));
    }

    private void writeCommands(Service.CLI service) {
        for (Service.CLI.Command command : service.commandList()) {
            this.processCommand(command);
        }
        List<Service.CLI.Command> confirmationCommands = this.confirmationCommands(service);
        this.confirmationOptions(service).forEach(o -> this.processConfirmationCommand((String)o, this.commandsOf(confirmationCommands, (String)o)));
    }

    private List<String> confirmationOptions(Service.CLI service) {
        return this.confirmationCommands(service).stream().map(c -> c.response().asConfirmation().options()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private List<Service.CLI.Command> confirmationCommands(Service.CLI service) {
        return service.commandList().stream().filter(c -> c.response().isConfirmation()).collect(Collectors.toList());
    }

    private List<Service.CLI.Command> commandsOf(List<Service.CLI.Command> commandList, String option) {
        return commandList.stream().filter(c -> c.response().asConfirmation().options().contains(option)).collect(Collectors.toList());
    }

    private void processCommand(Service.CLI.Command command) {
        FrameBuilder builder = this.buildFrame(command);
        String className = StringHelper.snakeCaseToCamelCase((String)command.name$()) + "Command";
        Commons.writeFrame(new File(String.valueOf(this.gen(Target.Server)) + File.separator + "cli" + File.separator + "commands"), className, this.commandTemplate().render((Object)builder));
        className = StringHelper.snakeCaseToCamelCase((String)command.name$()) + "Action";
        File srcFile = Commons.javaFile(new File(String.valueOf(this.src(Target.Server)) + File.separator + "actions"), className);
        if (!srcFile.exists()) {
            Commons.writeFrame(new File(String.valueOf(this.src(Target.Server)) + File.separator + "actions"), className, this.actionTemplate().render((Object)builder));
        }
    }

    private void processConfirmationCommand(String option, List<Service.CLI.Command> commandList) {
        FrameBuilder builder = this.buildConfirmationCommand(option, commandList);
        String className = StringHelper.snakeCaseToCamelCase((String)option) + "Command";
        Commons.writeFrame(new File(String.valueOf(this.gen(Target.Server)) + File.separator + "cli" + File.separator + "commands"), className, this.commandTemplate().render((Object)builder));
    }

    private FrameBuilder buildConfirmationCommand(String option, List<Service.CLI.Command> commandList) {
        FrameBuilder result = this.buildBaseFrame().add("command").add("confirmation");
        result.add("option", (Object)option);
        commandList.forEach(c -> result.add("condition", (Object)this.commandConditionFrame((Service.CLI.Command)((Object)c), option)));
        return result;
    }

    private FrameBuilder commandConditionFrame(Service.CLI.Command command, String option) {
        FrameBuilder result = new FrameBuilder(new String[]{"condition"});
        result.add("option", (Object)option);
        result.add("command", (Object)command.name());
        result.add("commandName", (Object)command.name$());
        return result;
    }

    private FrameBuilder buildFrame(Service.CLI service) {
        FrameBuilder result = this.buildBaseFrame().add("cli");
        Service.CLI.State initialState = service.stateList().stream().filter(Service.CLI.State::isInitial).findFirst().orElse(null);
        result.add("name", (Object)service.name$());
        result.add("initialState", (Object)(initialState != null ? initialState.name$() : ""));
        service.commandList().forEach(c -> result.add("command", (Object)this.commandFrameOf((Service.CLI.Command)((Object)c))));
        this.confirmationOptions(service).forEach(o -> result.add("confirmation", (Object)this.buildConfirmationCommand((String)o, Collections.emptyList())));
        return result;
    }

    private FrameBuilder buildFrame(Service.CLI.Command command) {
        FrameBuilder result = this.buildBaseFrame().add("command");
        result.add("name", (Object)command.name$());
        for (int i = 0; i < command.parameterList().size(); ++i) {
            result.add("parameter", this.frameOf(command.parameterList().get(i), i));
        }
        result.add("execute", this.executeFrameOf(command));
        result.add("response", (Object)this.frameOf(command.response()));
        return result;
    }

    private Object executeFrameOf(Service.CLI.Command command) {
        FrameBuilder result = this.buildBaseFrame().add("execute");
        result.add("name", (Object)command.name$());
        if (command.response().isMultiLine()) {
            result.add("multiline");
        }
        if (command.response().isConfirmation()) {
            Service.CLI.Command.Response.Confirmation confirmation = command.response().asConfirmation();
            result.add("confirmation");
            result.add("question", (Object)confirmation.question());
            confirmation.options().forEach(o -> result.add("option", o));
        }
        result.add("response", (Object)this.frameOf(command.response()));
        return result;
    }

    private Object frameOf(Parameter parameter, int index) {
        FrameBuilder result = new FrameBuilder(new String[]{"parameter"});
        if (parameter.isList()) {
            result.add("list");
        }
        result.add("name", (Object)parameter.name$());
        result.add("index", (Object)index);
        return result;
    }

    private FrameBuilder frameOf(Service.CLI.Command.Response response) {
        FrameBuilder result = this.buildBaseFrame().add("response");
        result.add("command", (Object)((Service.CLI.Command)response.core$().ownerAs(Service.CLI.Command.class)).name$());
        if (response.isText()) {
            result.add("text");
        }
        if (response.isConfirmation()) {
            result.add("confirmation");
            response.asConfirmation().options().forEach(o -> result.add("option", (Object)this.frameOf(response, (String)o)));
        }
        if (response.isMultiLine()) {
            result.add("multiline");
            response.asMultiLine().lineList().forEach(l -> result.add("line", (Object)this.frameOf(response, (Service.CLI.Command.Response.MultiLine.Line)((Object)l))));
        }
        return result;
    }

    private FrameBuilder frameOf(Service.CLI.Command.Response response, Service.CLI.Command.Response.MultiLine.Line line) {
        FrameBuilder result = new FrameBuilder(new String[]{"line"});
        if (line.isMultiple()) {
            result.add("multiple");
        }
        result.add("name", (Object)line.name$());
        result.add("addBreak", (Object)line.addBreak());
        result.add("multiple", (Object)this.multipleFrame(line));
        result.add("content", (Object)line.content());
        if (line.visibleWith() != null) {
            result.add("dependant", (Object)line.visibleWith().name$());
        }
        return result;
    }

    private FrameBuilder multipleFrame(Service.CLI.Command.Response.MultiLine.Line line) {
        FrameBuilder result = new FrameBuilder(new String[]{"multiple"});
        result.add("value", (Object)line.isMultiple());
        result.add("arrangement", (Object)(line.isMultiple() ? line.asMultiple().arrangement().name() : Service.CLI.Command.Response.MultiLine.Line.Multiple.Arrangement.Vertical.name()));
        return result;
    }

    private FrameBuilder frameOf(Service.CLI.Command.Response response, String option) {
        FrameBuilder result = new FrameBuilder(new String[]{"option"});
        Service.CLI.Command command = (Service.CLI.Command)response.core$().ownerAs(Service.CLI.Command.class);
        result.add("command", (Object)command.name());
        result.add("commandName", (Object)command.name$());
        result.add("value", (Object)option);
        return result;
    }

    private FrameBuilder commandFrameOf(Service.CLI.Command command) {
        FrameBuilder result = this.buildBaseFrame().add("command");
        result.add("name", (Object)command.name$());
        result.add("command", (Object)command.name());
        result.add("abbreviation", (Object)command.abbreviation());
        result.add("description", (Object)command.description());
        result.add("parameters", (Object)this.listFrame(command.parameterList().stream().map(Layer::name$).collect(Collectors.toList())));
        result.add("preconditions", (Object)this.listFrame(command.precondition() != null ? command.precondition().states().stream().map(Layer::name$).collect(Collectors.toList()) : Collections.emptyList()));
        if (command.postcondition() != null) {
            result.add("postcondition", (Object)command.postcondition().state().name$());
        }
        return result;
    }

    private FrameBuilder optionFrame(Service.CLI.Command command, String option) {
        FrameBuilder result = new FrameBuilder(new String[]{"option"});
        result.add("value", (Object)option);
        result.add("command", (Object)command.name());
        result.add("commandName", (Object)command.name$());
        return result;
    }

    private FrameBuilder listFrame(List<String> parameterList) {
        FrameBuilder result = new FrameBuilder(new String[]{"list"});
        if (parameterList.isEmpty()) {
            result.add("empty");
        }
        parameterList.forEach(p -> result.add("item", p));
        return result;
    }

    private Template template() {
        return Formatters.customize(new CliTemplate());
    }

    private Template commandTemplate() {
        return Formatters.customize(new CliCommandTemplate());
    }

    private Template actionTemplate() {
        return Formatters.customize(new CliActionTemplate());
    }
}

