/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.schema;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.schema.SchemaAnnotatedTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaHelper;
import io.intino.konos.builder.codegeneration.schema.SchemaTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaWriter;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Schema;
import java.io.File;

public class DefaultSchemaWriter
extends SchemaWriter {
    private boolean serializationAnnotations;

    public DefaultSchemaWriter(CompilationContext context, File destination, String packageName, boolean serializationAnnotations) {
        super(context, destination, packageName);
        this.serializationAnnotations = serializationAnnotations;
    }

    @Override
    public void write(Schema schema, Frame frame) {
        File packageFolder = this.schemaFolder(schema);
        Commons.writeFrame(packageFolder, schema.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", (Object)this.packageName).add("package", (Object)this.packageName(schema)).add("schema", (Object)frame)));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(schema), Commons.javaFile(packageFolder, schema.name$()).getAbsolutePath()));
    }

    private String packageName(Schema schema) {
        String subPackage = SchemaHelper.subPackage(schema);
        return subPackage.isEmpty() ? this.packageName : this.packageName + "." + subPackage.replace(File.separator, ".");
    }

    private Template template() {
        return Formatters.customize(this.serializationAnnotations ? new SchemaAnnotatedTemplate() : new SchemaTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

