/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.web;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.accessor.ui.web.templates.ThemeTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Format;
import io.intino.konos.dsl.Service;
import io.intino.konos.dsl.Theme;
import java.io.File;

public class ThemeRenderer
extends UIRenderer {
    private final Service.UI service;

    protected ThemeRenderer(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext);
        this.service = service;
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder(new String[]{"theme"});
        Theme theme = this.service.graph().theme();
        if (theme != null) {
            builder.add("palette", (Object)this.palette(theme));
            builder.add("typography", (Object)this.typography(theme));
            if (theme.readonly() != null) {
                builder.add("format", (Object)this.frameOf("readonly", theme.readonly().format().content()));
            }
        }
        this.service.graph().formatList().forEach(r -> builder.add("format", (Object)this.frameOf((Format)((Object)r))));
        Commons.write(new File(String.valueOf(this.gen(Target.Accessor)) + File.separator + "Theme.js").toPath(), this.setup(new ThemeTemplate()).render((Object)builder.toFrame()));
    }

    private Frame palette(Theme theme) {
        FrameBuilder result = new FrameBuilder(new String[]{"palette"});
        if (theme.type() != Theme.Type.Normal) {
            result.add("type", (Object)theme.type().name());
        }
        if (theme.primary() != null) {
            result.add("primary", (Object)theme.primary().color());
        }
        if (theme.secondary() != null) {
            result.add("secondary", (Object)theme.secondary().color());
        }
        if (theme.error() != null) {
            result.add("error", (Object)theme.error().color());
        }
        result.add("contrastThreshold", (Object)theme.contrastThreshold());
        result.add("tonalOffset", (Object)theme.tonalOffset());
        return result.toFrame();
    }

    private Frame typography(Theme theme) {
        Theme.Typography typography = theme.typography();
        if (typography == null) {
            typography = theme.create().typography();
        }
        FrameBuilder result = new FrameBuilder(new String[]{"typography"});
        result.add("fontFamily", (Object)("\"" + String.join((CharSequence)"\",\"", typography.fontFamily()) + "\""));
        result.add("fontSize", (Object)typography.fontSize());
        return result.toFrame();
    }

    private Frame frameOf(Format format) {
        return this.frameOf(format.name$(), format.content());
    }

    private Frame frameOf(String formatName, String content) {
        FrameBuilder result = new FrameBuilder(new String[]{"format"});
        result.add("name", (Object)formatName);
        result.add("content", (Object)(content != null ? content : ""));
        return result.toFrame();
    }
}

