/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.messaging;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.accessor.messaging.MessagingAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Parameter;
import io.intino.konos.dsl.Response;
import io.intino.konos.dsl.Service;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessagingAccessorRenderer
extends Renderer {
    private final Service.Messaging service;
    private File destination;

    public MessagingAccessorRenderer(CompilationContext compilationContext, Service.Messaging application, File destination) {
        super(compilationContext);
        this.service = application;
        this.destination = destination;
    }

    @Override
    public void render() throws KonosException {
        new SchemaListRenderer(this.context, this.service.graph(), this.destination).execute();
        this.processService(this.service);
    }

    private void processService(Service.Messaging jmsService) {
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        builder.add("name", (Object)jmsService.name$());
        builder.add("package", (Object)this.packageName());
        if (!jmsService.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        List requests = jmsService.core$().findNode(Service.Messaging.Request.class);
        Set<String> customParameters = this.extractCustomParameters(requests);
        builder.add("request", requests.stream().map(request -> this.processRequest((Service.Messaging.Request)((Object)request), jmsService).toFrame()).toArray(Frame[]::new));
        for (String parameter : customParameters) {
            builder.add("custom", (Object)parameter);
        }
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)jmsService.name$()) + "Accessor", this.getTemplate().render((Object)builder.toFrame()));
    }

    private Set<String> extractCustomParameters(List<Service.Messaging.Request> requests) {
        HashSet<String> set = new HashSet<String>();
        for (Service.Messaging.Request request : requests) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private FrameBuilder processRequest(Service.Messaging.Request request, Service.Messaging service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("service", (Object)service.name$()).add("path", (Object)("service" + this.chainContext(service.context()) + request.path()));
        if (request.parameter() != null) {
            builder.add("parameter", (Object)this.parameterFrame(request.parameter()));
        }
        if (request.response() != null && request.response().isType()) {
            builder.add("reply");
            builder.add("response", (Object)this.responseFrame(request.response()));
        }
        return builder;
    }

    private String chainContext(String context) {
        return context != null && !context.isEmpty() ? "." + context + "." : "";
    }

    private Frame parameterFrame(Parameter parameter) {
        return new FrameBuilder(new String[]{"value"}).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Frame responseFrame(Response response) {
        return new FrameBuilder(new String[]{"value"}).add("name", (Object)response.name$()).add("type", (Object)response.asType().type()).toFrame();
    }

    private Template getTemplate() {
        return new MessagingAccessorTemplate().add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString())).add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value).add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

