/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos;

import io.intino.Configuration;
import io.intino.konos.builder.CompilerConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class CompilationInfoExtractor {
    private static final Logger LOG = Logger.getGlobal();

    CompilationInfoExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getInfoFromArgsFile(File argsFile, CompilerConfiguration configuration, Map<File, Boolean> srcFiles) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(argsFile)));
            CompilationInfoExtractor.processArgs(configuration, reader, CompilationInfoExtractor.readSrc(srcFiles, "def.file", reader));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error getting Args IO: " + e.getMessage(), e);
        }
        finally {
            try {
                assert (reader != null);
                reader.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error getting Args IO2: " + e.getMessage(), e);
            }
        }
    }

    private static String readSrc(Map<File, Boolean> srcFiles, String type, BufferedReader reader) throws IOException {
        String line;
        while (!"".equals(line = reader.readLine())) {
            if (type.equals(line)) continue;
            String[] split = line.split("#");
            File file = new File(split[0]);
            srcFiles.put(file, Boolean.valueOf(split[1]));
        }
        return line;
    }

    private static void processArgs(CompilerConfiguration configuration, BufferedReader reader, String line) throws IOException {
        String aLine = line;
        while (aLine != null) {
            CompilationInfoExtractor.processLine(configuration, reader, aLine);
            aLine = reader.readLine();
        }
    }

    private static void processLine(CompilerConfiguration configuration, BufferedReader reader, String aLine) throws IOException {
        switch (aLine) {
            case "encoding": {
                configuration.sourceEncoding(reader.readLine());
                break;
            }
            case "outputpath": {
                configuration.genDirectory(new File(reader.readLine()));
                break;
            }
            case "final_outputpath": {
                configuration.outDirectory(new File(reader.readLine()));
                break;
            }
            case "src.path": {
                configuration.srcDirectory(new File(reader.readLine()));
                break;
            }
            case "res.path": {
                configuration.resDirectory(new File(reader.readLine()));
                break;
            }
            case "project": {
                configuration.setProject(reader.readLine());
                break;
            }
            case "module": {
                configuration.module(reader.readLine());
                break;
            }
            case "dsl": {
                configuration.dsl().name(reader.readLine());
                break;
            }
            case "dsl.generation.package": {
                configuration.dsl().generationPackage(reader.readLine());
                break;
            }
            case "parent.interface": {
                configuration.parentInterface(reader.readLine());
                break;
            }
            case "datahub": {
                configuration.datahubLibrary(CompilationInfoExtractor.findLibraryInRepository(reader.readLine()));
                break;
            }
            case "current.dependencies": {
                configuration.currentDependencies(Arrays.asList(reader.readLine().split(",")));
                break;
            }
            case "distribution.snapshot": {
                configuration.currentDependencies(Arrays.asList(reader.readLine().split(",")));
                break;
            }
            case "distribution.release": {
                configuration.releaseDistributionRepository(CompilationInfoExtractor.confOf(reader.readLine().split("#")));
                break;
            }
            case "archetype": {
                configuration.archetypeLibrary(CompilationInfoExtractor.findLibraryInRepository(reader.readLine()));
                break;
            }
            case "project.path": {
                configuration.projectDirectory(new File(reader.readLine()));
                break;
            }
            case "module.path": {
                configuration.moduleDirectory(new File(reader.readLine()));
                break;
            }
            case "level": {
                configuration.dsl().level(Configuration.Artifact.Dsl.Level.valueOf((String)reader.readLine()));
                break;
            }
            case "groupId": {
                configuration.groupId(reader.readLine());
                break;
            }
            case "artifactId": {
                configuration.artifactId(reader.readLine());
                break;
            }
            case "version": {
                configuration.version(reader.readLine());
                break;
            }
            case "module.parameters": {
                configuration.parameters(reader.readLine().split(";"));
                break;
            }
            case "generation.package": {
                configuration.generationPackage(reader.readLine());
                break;
            }
            case "def.file": {
                CompilationInfoExtractor.readSrcPaths(configuration.sources(), reader);
                break;
            }
            case "intino.project.path": {
                configuration.intinoProjectDirectory(new File(reader.readLine()));
                break;
            }
            case "compilation.mode": {
                configuration.mode(reader.readLine());
                break;
            }
        }
    }

    private static Configuration.Repository confOf(final String[] split) {
        return new Configuration.Repository(){

            public String identifier() {
                return split[0];
            }

            public String url() {
                return split[1];
            }

            public String user() {
                return null;
            }

            public String password() {
                return null;
            }

            public Configuration.Repository.UpdatePolicy updatePolicy() {
                return null;
            }

            public Configuration root() {
                return null;
            }

            public Configuration.ConfigurationNode owner() {
                return null;
            }
        };
    }

    private static File findLibraryInRepository(String library) {
        String[] split = library.split(":");
        File directory = new File(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository" + File.separator + split[0].replace(".", File.separator) + File.separator + split[1] + File.separator + split[2]);
        return new File(directory, split[1] + "-" + split[2] + ".jar");
    }

    private static void readSrcPaths(List<File> srcPaths, BufferedReader reader) throws IOException {
        String line;
        while (!"".equals(line = reader.readLine())) {
            srcPaths.add(new File(line));
        }
    }
}

