/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.verification.verifiers;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.verification.VerificationException;
import io.intino.itrules.template.verification.verifiers.Verifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TerminationVerifier
implements Verifier<Frame> {
    @Override
    public boolean verify(Frame frame) throws VerificationException {
        return this.isAcyclic(this.graphOf(frame));
    }

    private Map<Frame, List<Frame>> graphOf(Frame root) throws VerificationException {
        try {
            HashMap<Frame, List<Frame>> graph = new HashMap<Frame, List<Frame>>();
            ArrayDeque<Frame> stack = new ArrayDeque<Frame>(List.of(root));
            while (!stack.isEmpty()) {
                Frame current = (Frame)stack.pop();
                if (graph.containsKey(current)) continue;
                List<Frame> deps = this.dependenciesOf(current);
                graph.put(current, deps);
                for (Frame dep : deps) {
                    if (graph.containsKey(dep)) continue;
                    stack.push(dep);
                }
            }
            return graph;
        }
        catch (Throwable e) {
            throw new VerificationException(e.getMessage());
        }
    }

    private List<Frame> dependenciesOf(Frame frame) {
        if (frame instanceof FrameBuilder.Composite) {
            FrameBuilder.Composite c = (FrameBuilder.Composite)frame;
            return c.slots().values().stream().flatMap(Collection::stream).filter(f -> f instanceof FrameBuilder.Composite).toList();
        }
        return List.of();
    }

    private boolean isAcyclic(Map<Frame, List<Frame>> graph) {
        HashMap indegree = new HashMap();
        graph.keySet().forEach(v -> {
            indegree.putIfAbsent(v, 0);
            ((List)graph.get(v)).forEach(w -> indegree.merge(w, 1, Integer::sum));
        });
        ArrayDeque<Frame> queue = new ArrayDeque<Frame>();
        for (Map.Entry e : indegree.entrySet()) {
            if ((Integer)e.getValue() != 0) continue;
            queue.add((Frame)e.getKey());
        }
        int visited = 0;
        while (!queue.isEmpty()) {
            Frame v2 = (Frame)queue.remove();
            ++visited;
            List neighbors = graph.getOrDefault(v2, List.of());
            neighbors.forEach(w -> {
                int d = (Integer)indegree.get(w) - 1;
                indegree.put(w, d);
                if (d == 0) {
                    queue.add((Frame)w);
                }
            });
        }
        return visited == indegree.size();
    }
}

