/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.verification.verifiers;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.BinaryExpression;
import io.intino.itrules.template.condition.BinaryOperator;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.NotExpression;
import io.intino.itrules.template.condition.predicates.AttributePredicate;
import io.intino.itrules.template.condition.predicates.TriggerPredicate;
import io.intino.itrules.template.condition.predicates.TypePredicate;
import io.intino.itrules.template.verification.verifiers.Verifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DeterminacyVerifier
implements Verifier<Template> {
    @Override
    public boolean verify(Template template) {
        List<Rule> rules = template.ruleSet();
        int n = rules.size();
        if (n <= 1) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            Rule ri = rules.get(i);
            for (int j = i + 1; j < n; ++j) {
                Rule rj = rules.get(j);
                if (this.areMutuallyExclusive(ri.condition(), rj.condition())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areMutuallyExclusive(LogicalExpression c1, LogicalExpression c2) {
        LogicalExpression nnf1 = this.toNNF(c1, false);
        LogicalExpression nnf2 = this.toNNF(c2, false);
        List<Set<Atom>> dnf1 = this.toDNF(nnf1);
        List<Set<Atom>> dnf2 = this.toDNF(nnf2);
        for (Set<Atom> conj1 : dnf1) {
            if (!dnf2.stream().anyMatch(conj2 -> this.isConjunctionSatisfiable(conj1, (Set<Atom>)conj2))) continue;
            return false;
        }
        return true;
    }

    private boolean isConjunctionSatisfiable(Set<Atom> c1, Set<Atom> c2) {
        ArrayList<Atom> all = new ArrayList<Atom>(c1.size() + c2.size());
        all.addAll(c1);
        all.addAll(c2);
        for (int i = 0; i < all.size(); ++i) {
            Atom li = (Atom)all.get(i);
            for (int j = i + 1; j < all.size(); ++j) {
                Atom lj = (Atom)all.get(j);
                if (li.kind != lj.kind || !Objects.equals(li.name, lj.name) || !Objects.equals(li.value, lj.value) || li.positive == lj.positive) continue;
                return false;
            }
        }
        HashMap<String, Object> attrValues = new HashMap<String, Object>();
        for (Atom l : all) {
            Object prev;
            if (l.kind != Atom.Kind.ATTRIBUTE || !l.positive || (prev = attrValues.putIfAbsent(l.name, l.value)) == null || Objects.equals(prev, l.value)) continue;
            return false;
        }
        String trigger = null;
        for (Atom l : all) {
            if (l.kind != Atom.Kind.TRIGGER || !l.positive) continue;
            if (trigger == null) {
                trigger = l.name;
                continue;
            }
            if (trigger.equals(l.name)) continue;
            return false;
        }
        return true;
    }

    private LogicalExpression toNNF(LogicalExpression expr, boolean negated) {
        if (expr instanceof NotExpression) {
            NotExpression n = (NotExpression)expr;
            return this.toNNF(n.expression(), !negated);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression b = (BinaryExpression)expr;
            LogicalExpression left = this.toNNF(b.left(), negated);
            LogicalExpression right = this.toNNF(b.right(), negated);
            if (!negated) {
                return new BinaryExpression(left, b.operator(), right);
            }
            BinaryOperator op = b.operator() == BinaryOperator.AND ? BinaryOperator.OR : BinaryOperator.AND;
            return new BinaryExpression(left, op, right);
        }
        if (negated) {
            return new NotExpression(expr);
        }
        return expr;
    }

    private List<Set<Atom>> toDNF(LogicalExpression exprNNF) {
        if (exprNNF instanceof BinaryExpression) {
            ArrayList<Set<Atom>> result;
            BinaryExpression b = (BinaryExpression)exprNNF;
            List<Set<Atom>> left = this.toDNF(b.left());
            List<Set<Atom>> right = this.toDNF(b.right());
            if (b.operator() == BinaryOperator.AND) {
                result = new ArrayList<Set<Atom>>();
                for (Set<Atom> c1 : left) {
                    for (Set<Atom> c2 : right) {
                        HashSet<Atom> conj = new HashSet<Atom>(c1);
                        conj.addAll(c2);
                        result.add(conj);
                    }
                }
            } else {
                result = new ArrayList(left.size() + right.size());
                result.addAll(left);
                result.addAll(right);
            }
            return result;
        }
        if (exprNNF instanceof NotExpression) {
            NotExpression n = (NotExpression)exprNNF;
            Atom inner = this.toAtom(n.expression(), true);
            Atom neg = new Atom(inner.kind, inner.name, inner.value, false);
            return List.of(Set.of(neg));
        }
        return List.of(Set.of(this.toAtom(exprNNF, true)));
    }

    private Atom toAtom(LogicalExpression atom, boolean positive) {
        if (atom instanceof TriggerPredicate) {
            TriggerPredicate t = (TriggerPredicate)atom;
            return new Atom(Atom.Kind.TRIGGER, t.name(), null, positive);
        }
        if (atom instanceof AttributePredicate) {
            AttributePredicate a = (AttributePredicate)atom;
            return new Atom(Atom.Kind.ATTRIBUTE, a.attribute(), a.value(), positive);
        }
        if (atom instanceof TypePredicate) {
            TypePredicate tp = (TypePredicate)atom;
            return new Atom(Atom.Kind.TYPE, tp.types()[0], null, positive);
        }
        throw new IllegalArgumentException("Unexpected atom type: " + String.valueOf(atom.getClass()));
    }

    public static final class Atom {
        final Kind kind;
        final String name;
        final Object value;
        final boolean positive;

        public Atom(Kind kind, String name, Object value, boolean positive) {
            this.kind = kind;
            this.name = name;
            this.value = value;
            this.positive = positive;
        }

        Atom negated() {
            return new Atom(this.kind, this.name, this.value, !this.positive);
        }

        public String toString() {
            return (this.positive ? "" : "not ") + String.valueOf((Object)this.kind) + "(" + this.name + (String)(this.kind == Kind.ATTRIBUTE ? "=" + String.valueOf(this.value) : "") + ")";
        }

        static enum Kind {
            TYPE,
            TRIGGER,
            ATTRIBUTE;

        }
    }
}

