/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.verification;

import io.intino.itrules.template.verification.Issue;
import java.util.List;
import java.util.stream.Collectors;

public final class VerificationReport {
    private final Status status;
    private final List<Issue> issues;

    private VerificationReport(List<Issue> issues) {
        this.issues = List.copyOf(issues);
        this.status = issues.isEmpty() ? Status.FAILED : Status.OK;
    }

    public static VerificationReport ok() {
        return new VerificationReport(List.of());
    }

    public static VerificationReport ofIssues(List<Issue> issues) {
        return new VerificationReport(issues);
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public String toString() {
        String header = "VerificationReport{status=" + String.valueOf((Object)this.status) + ", issues=" + this.issues.size() + "}";
        if (this.issues.isEmpty()) {
            return header;
        }
        String details = this.issues.stream().map(Issue::toString).collect(Collectors.joining("\n  - ", "\n  - ", ""));
        return header + details;
    }

    public static enum Status {
        OK,
        FAILED;

    }

    public static enum IssueCode {
        FINITE_VIOLATION("Termination (finiteness) check failed"),
        STRATIFICATION_VIOLATION("Determinacy/stratification check failed"),
        PARTITION_VIOLATION("Completeness/partition check failed"),
        REFERENTIAL_CONSISTENCY_VIOLATION("Referential consistency check failed");

        private final String message;

        private IssueCode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

