/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.verification;

import io.intino.itrules.Frame;
import io.intino.itrules.template.verification.Issue;
import io.intino.itrules.template.verification.VerificationException;
import io.intino.itrules.template.verification.VerificationReport;
import io.intino.itrules.template.verification.verifiers.TerminationVerifier;
import java.util.ArrayList;

public interface Verifiable {
    default public boolean checkTermination(Frame frame) {
        try {
            return new TerminationVerifier().verify(frame);
        }
        catch (VerificationException e) {
            return false;
        }
    }

    public boolean checkDeterminacy();

    public boolean checkCompleteness(Frame var1);

    public boolean checkReferentialConsistency(Frame var1);

    default public VerificationReport verify(Frame frame) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (!this.checkTermination(frame)) {
            issues.add(Issue.error(VerificationReport.IssueCode.FINITE_VIOLATION));
        }
        if (!this.checkDeterminacy()) {
            issues.add(Issue.error(VerificationReport.IssueCode.STRATIFICATION_VIOLATION));
        }
        if (!this.checkCompleteness(frame)) {
            issues.add(Issue.error(VerificationReport.IssueCode.PARTITION_VIOLATION));
        }
        if (!this.checkReferentialConsistency(frame)) {
            issues.add(Issue.error(VerificationReport.IssueCode.REFERENTIAL_CONSISTENCY_VIOLATION));
        }
        return issues.isEmpty() ? VerificationReport.ok() : VerificationReport.ofIssues(issues);
    }
}

