/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.condition;

import io.intino.itrules.Trigger;
import io.intino.itrules.template.condition.BinaryOperator;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.Predicate;

public record BinaryExpression(LogicalExpression left, BinaryOperator operator, LogicalExpression right) implements LogicalExpression
{
    @Override
    public boolean evaluate(Trigger trigger) {
        if (this.operator == BinaryOperator.AND) {
            return this.left.evaluate(trigger) && this.right.evaluate(trigger);
        }
        return this.left.evaluate(trigger) || this.right.evaluate(trigger);
    }

    @Override
    public String toString() {
        return this.embrace(this.left) + " " + this.operator.name() + " " + this.embrace(this.right);
    }

    private String embrace(LogicalExpression expression) {
        String result = expression.toString();
        return expression instanceof Predicate ? result : "(" + result + ")";
    }
}

