/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template;

import io.intino.itrules.Frame;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.verification.Verifiable;
import io.intino.itrules.template.verification.VerificationException;
import io.intino.itrules.template.verification.verifiers.CompletenessVerifier;
import io.intino.itrules.template.verification.verifiers.DeterminacyVerifier;
import io.intino.itrules.template.verification.verifiers.ReferenceConsistencyVerifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class Template
implements Verifiable {
    private final Configuration configuration;
    public static final Template EMPTY = Template.with(List.of());

    public Template() {
        this(new Configuration());
    }

    public Template(Configuration configuration) {
        this.configuration = configuration;
    }

    public abstract List<Rule> ruleSet();

    public Configuration configuration() {
        return this.configuration;
    }

    public static Template compose(Template t, Template ... templates) {
        final ArrayList<Rule> rules = new ArrayList<Rule>(t.ruleSet());
        for (Template template : templates) {
            rules.addAll(template.ruleSet());
        }
        return new Template(){

            @Override
            public List<Rule> ruleSet() {
                return rules;
            }
        };
    }

    @Override
    public boolean checkDeterminacy() {
        return new DeterminacyVerifier().verify(this);
    }

    @Override
    public boolean checkCompleteness(Frame frame) {
        try {
            return new CompletenessVerifier(this).verify(frame);
        }
        catch (VerificationException e) {
            return false;
        }
    }

    @Override
    public boolean checkReferentialConsistency(Frame frame) {
        try {
            return new ReferenceConsistencyVerifier(this).verify(frame);
        }
        catch (VerificationException e) {
            return false;
        }
    }

    protected Rule rule() {
        return new Rule();
    }

    public static Template with(final List<Rule> rules) {
        return new Template(){

            @Override
            public List<Rule> ruleSet() {
                return rules;
            }
        };
    }

    public record Configuration(Locale locale, LineSeparator separator) {
        public Configuration() {
            this(Locale.ENGLISH, LineSeparator.LF);
        }

        public boolean isCRLF() {
            return this.separator() == LineSeparator.CRLF;
        }

        public static enum LineSeparator {
            LF,
            CRLF;

        }
    }
}

