/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.outputs;

import io.intino.itrules.template.Output;

public class Placeholder
implements Output {
    private static final String OptionSeparator = "+";
    public static final String THIS = "this";
    public static final Output This = new Placeholder("", new String[0]);
    private final boolean isThis;
    private final String name;
    private final String[] formatters;
    private final String[] targetPath;
    private String separator = null;

    public Placeholder(String name, String ... formatters) {
        this(name, (String[])null, formatters);
    }

    public Placeholder(String name, String[] targetPath, String ... formatters) {
        this.isThis = name.equals(THIS) || name.isEmpty();
        this.name = this.isThis ? "" : name;
        this.targetPath = targetPath;
        this.formatters = formatters;
    }

    public String name() {
        return this.name;
    }

    public String[] targetPath() {
        return this.targetPath;
    }

    public String[] formatters() {
        return this.formatters;
    }

    public String separator() {
        return this.separator;
    }

    public boolean isThis() {
        return this.isThis;
    }

    private boolean isMultiple() {
        return this.separator != null;
    }

    public String fullName() {
        StringBuilder result = new StringBuilder(this.name);
        if (this.targetPath != null) {
            result.append("<").append(String.join((CharSequence)".", this.targetPath)).append(">");
        }
        for (String formatter : this.formatters) {
            result.append(OptionSeparator).append(formatter);
        }
        return result.toString();
    }

    public Placeholder multiple(String separator) {
        this.separator = separator;
        return this;
    }

    public String toString() {
        return "$" + this.fullName() + (String)(this.isMultiple() ? "...[" + (this.separator != null ? this.separator : ":") + "]" : "");
    }
}

