/*
 * Copyright 2024
 * Octavio Roncal Andrés
 * José Juan Hernández Cabrera
 * José Évora Gomez
 *
 * This File is Part of ItRules Project
 *
 * ItRules Project is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ItRules Project is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with itrules Library.  If not, see <http://www.gnu.org/licenses/>.
 */

package io.intino.itrules;

import io.intino.itrules.parser.ITRulesSyntaxError;
import io.intino.itrules.parser.TemplateParser;
import io.intino.itrules.template.Template;

import java.io.InputStream;
import java.nio.charset.Charset;

public final class TemplateReader {
	private final InputStream inputStream;
	private Template template;

	public TemplateReader(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public Template read() throws ITRulesSyntaxError {
		return read(Charset.defaultCharset());
	}

	public Template read(Charset charset) throws ITRulesSyntaxError {
		return new TemplateParser().parse(inputStream, charset);
	}
}
