/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.serializer;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.serializer.JavaItrulesTemplate;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.BinaryExpression;
import io.intino.itrules.template.condition.BinaryOperator;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.NotExpression;
import io.intino.itrules.template.condition.predicates.AttributePredicate;
import io.intino.itrules.template.condition.predicates.TriggerPredicate;
import io.intino.itrules.template.condition.predicates.TypePredicate;
import io.intino.itrules.template.outputs.Expression;
import io.intino.itrules.template.outputs.Literal;
import io.intino.itrules.template.outputs.Placeholder;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemplateSerializer {
    private final String name;
    private final String aPackage;
    private final Locale locale;
    private final Template.Configuration.LineSeparator lineSeparator;

    public TemplateSerializer(String name, String aPackage, Locale locale, Template.Configuration.LineSeparator lineSeparator) {
        this.name = name;
        this.aPackage = aPackage;
        this.locale = locale;
        this.lineSeparator = lineSeparator;
    }

    public String toJava(Template template) {
        return new Engine((Template)new JavaItrulesTemplate(new Template.Configuration(this.locale, this.lineSeparator))).add("string", this.buildStringFormatter()).render((Object)this.frameOf(template));
    }

    private Frame frameOf(Template template) {
        FrameBuilder builder = new FrameBuilder(new String[]{"template"});
        builder.add("name", (Object)this.name);
        builder.add("locale", (Object)this.locale);
        builder.add("lineSeparator", (Object)this.lineSeparator);
        if (!this.aPackage.isEmpty()) {
            builder.add("package", (Object)this.aPackage);
        }
        template.ruleSet().forEach(r -> builder.add("rule", (Object)this.frameOf((Rule)r)));
        return builder.toFrame();
    }

    private Frame frameOf(Rule r) {
        FrameBuilder builder = new FrameBuilder(new String[]{"rule"});
        builder.add("condition", (Object)this.toString(r.condition()));
        builder.add("outputs", (Object)this.frameOf(r.outputs()));
        return builder.toFrame();
    }

    private Frame[] frameOf(Stream<Output> outputs) {
        return (Frame[])outputs.map(this::map).toArray(Frame[]::new);
    }

    private Frame map(Output o) {
        if (o instanceof Literal) {
            Literal l = (Literal)o;
            return new FrameBuilder(new String[]{"output", "literal"}).add("value", (Object)l.toString()).toFrame();
        }
        if (o instanceof Placeholder) {
            Placeholder p = (Placeholder)o;
            FrameBuilder builder = new FrameBuilder(new String[]{"output", "placeholder"}).add("name", (Object)p.name());
            if (p.separator() != null) {
                builder.add("separator", (Object)p.separator());
            }
            if (p.formatters() != null) {
                builder.add("formatters", (Object)p.formatters());
            }
            return builder.toFrame();
        }
        if (o instanceof Expression) {
            Expression e = (Expression)o;
            FrameBuilder builder = new FrameBuilder(new String[]{"output", "expression"});
            e.outputs().forEach(op -> builder.add("outputs", (Object)this.map((Output)op)));
            if (e.next() != null) {
                builder.add("next", (Object)this.map((Output)e.next()));
            }
            return builder.toFrame();
        }
        return null;
    }

    private String toString(LogicalExpression source) {
        if (source instanceof BinaryExpression) {
            BinaryExpression b = (BinaryExpression)source;
            return (b.operator().equals((Object)BinaryOperator.AND) ? "all(" : "any(") + this.toString(b.left()) + ", " + this.toString(b.right()) + ")";
        }
        if (source instanceof NotExpression) {
            NotExpression n = (NotExpression)source;
            return "not(" + this.toString(n.expression()) + ")";
        }
        if (source instanceof TypePredicate) {
            TypePredicate t = (TypePredicate)source;
            return "allTypes(" + Arrays.stream(t.types()).map(this::quoted).collect(Collectors.joining(", ")) + ")";
        }
        if (source instanceof AttributePredicate) {
            AttributePredicate a = (AttributePredicate)source;
            return "attribute(" + this.quoted(a.attribute()) + (String)(a.value() != null ? "," + this.quoted(a.value().toString()) : "") + ")";
        }
        if (source instanceof TriggerPredicate) {
            TriggerPredicate t = (TriggerPredicate)source;
            return "trigger(" + this.quoted(t.name()) + ")";
        }
        return "";
    }

    private String quoted(String value) {
        return "\"" + value + "\"";
    }

    private Formatter buildStringFormatter() {
        return object -> {
            String value = object.toString();
            if (value.contains("\r")) {
                value = value.replace("\r", "\\r");
            }
            value = value.replace("\n", "\\n");
            if ((value = value.replace("\t", "\\t").replace("\"", "\\\"")).equals("\\")) {
                value = value.replace("\\", "\\\\");
            }
            return "\"" + value + "\"";
        };
    }
}

