/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.parser;

import io.intino.itrules.Logger;
import io.intino.itrules.dsl.ItrParser;
import io.intino.itrules.dsl.ItrParserBaseListener;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.BinaryExpression;
import io.intino.itrules.template.condition.BinaryOperator;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.NotExpression;
import io.intino.itrules.template.condition.predicates.AttributePredicate;
import io.intino.itrules.template.condition.predicates.TriggerPredicate;
import io.intino.itrules.template.condition.predicates.TypePredicate;
import io.intino.itrules.template.outputs.Expression;
import io.intino.itrules.template.outputs.Literal;
import io.intino.itrules.template.outputs.Placeholder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class Interpreter
extends ItrParserBaseListener {
    private static final String NL_SEPARATOR = "$NL";
    private static final String TAB_SEPARATOR = "$TAB";
    private final List<Rule> collectedRules = new ArrayList<Rule>();
    private final Logger logger;
    private Rule currentRule;
    private StringBuilder currentText = new StringBuilder();

    public Interpreter(Logger logger) {
        this.logger = logger;
    }

    public Template template() {
        return Template.with(this.collectedRules);
    }

    @Override
    public void enterSignature(ItrParser.SignatureContext ctx) {
        this.currentRule = new Rule();
        this.collectedRules.add(this.currentRule);
        this.currentRule.condition(this.process(ctx.condition()));
    }

    private LogicalExpression process(ItrParser.ConditionContext condition) {
        List<LogicalExpression> terms = condition.term().stream().map(this::process).toList();
        if (terms.isEmpty()) {
            return null;
        }
        if (terms.size() == 1) {
            return terms.get(0);
        }
        LogicalExpression root = terms.get(0);
        List<ItrParser.OperatorContext> operators = condition.operator();
        for (int i = 0; i < operators.size(); ++i) {
            root = new BinaryExpression(root, operators.get(i).AND() != null ? BinaryOperator.AND : BinaryOperator.OR, terms.get(i + 1));
        }
        return root;
    }

    private LogicalExpression process(ItrParser.TermContext term) {
        LogicalExpression result = term.predicate() != null ? this.predicateOf(term.predicate().NAME().getText(), term.predicate().parameters()) : this.process(term.condition());
        return term.NOT() != null ? new NotExpression(result) : result;
    }

    private LogicalExpression predicateOf(String name, ItrParser.ParametersContext parameters) {
        String[] params = (String[])parameters.parameter().stream().map(RuleContext::getText).map(p -> p.replaceAll("\\s|\u00a0", "")).toArray(String[]::new);
        if (name.equalsIgnoreCase("type")) {
            return new TypePredicate(params);
        }
        if (name.equalsIgnoreCase("attribute")) {
            return new AttributePredicate(params[0], params.length > 1 ? params[1] : null);
        }
        if (name.equalsIgnoreCase("trigger")) {
            return new TriggerPredicate(params[0]);
        }
        return null;
    }

    @Override
    public void enterText(ItrParser.TextContext ctx) {
        if (ctx.getParent() instanceof ItrParser.BodyContext) {
            this.currentText.append(ctx.getText());
        }
    }

    @Override
    public void exitText(ItrParser.TextContext ctx) {
        if (ctx.getParent() instanceof ItrParser.BodyContext && this.isEndTextSequence(ctx)) {
            this.currentRule.output(new Output[]{new Literal(this.currentText.toString())});
            this.currentText = new StringBuilder();
        }
    }

    private boolean isEndTextSequence(ItrParser.TextContext ctx) {
        ItrParser.BodyContext parent = (ItrParser.BodyContext)ctx.getParent();
        List children = parent.children;
        return children.indexOf((Object)ctx) + 1 >= children.size() || !(children.get(children.indexOf((Object)ctx) + 1) instanceof ItrParser.TextContext);
    }

    @Override
    public void enterExpression(ItrParser.ExpressionContext ctx) {
        Expression expression = new Expression(new Output[0]);
        Expression currentOr = null;
        boolean orMode = false;
        String indent = this.calculateExpressionIndent(ctx);
        for (ParseTree child : ctx.children) {
            if (!orMode && child instanceof ItrParser.ExpressionBodyContext) {
                this.fillExpression((ItrParser.ExpressionBodyContext)child, expression, indent);
                continue;
            }
            if (child instanceof ItrParser.ExpressionBodyContext) {
                this.fillExpression((ItrParser.ExpressionBodyContext)child, currentOr, indent);
                continue;
            }
            if (!child.getText().equals("?")) continue;
            if (currentOr != null) {
                expression.next(currentOr);
            }
            orMode = true;
            currentOr = new Expression(new Output[0]);
        }
        if (currentOr != null) {
            expression.next(currentOr);
        }
        this.currentRule.output(new Output[]{expression});
    }

    private void fillExpression(ItrParser.ExpressionBodyContext body, Expression expression, String indent) {
        for (ParseTree token : body.children) {
            if (token instanceof ItrParser.PlaceholderContext) {
                if (token.getText().equals(NL_SEPARATOR)) {
                    expression.output(new Output[]{new Literal("\n")});
                    continue;
                }
                if (token.getText().equals(TAB_SEPARATOR)) {
                    expression.output(new Output[]{new Literal("\t")});
                    continue;
                }
                expression.output(new Output[]{this.processPlaceHolder((ItrParser.PlaceholderContext)token)});
                continue;
            }
            if (!(token instanceof ItrParser.TextContext)) continue;
            expression.output(new Output[]{new Literal(this.clean(token).replaceFirst(indent, ""))});
        }
    }

    private String clean(ParseTree child) {
        return child.getText().startsWith("~") ? child.getText().substring(1) : child.getText();
    }

    @Override
    public void enterPlaceholder(ItrParser.PlaceholderContext ctx) {
        if (!this.inExpression(ctx)) {
            if (ctx.getText().equals(NL_SEPARATOR)) {
                this.currentRule.output(new Output[]{new Literal("\n")});
            } else if (ctx.getText().equals(TAB_SEPARATOR)) {
                this.currentRule.output(new Output[]{new Literal("\t")});
            } else {
                this.currentRule.output(new Output[]{this.processPlaceHolder(ctx)});
            }
        }
    }

    private boolean inExpression(ItrParser.PlaceholderContext ctx) {
        return ctx.getParent() instanceof ItrParser.ExpressionBodyContext;
    }

    private Placeholder processPlaceHolder(ItrParser.PlaceholderContext ctx) {
        String separator;
        TerminalNode target = ctx.TARGET();
        String[] options = this.options(ctx.option());
        String string = separator = ctx.SEPARATOR() != null ? ctx.SEPARATOR().getText() : null;
        if (separator != null) {
            separator = this.format(separator);
        }
        return new Placeholder(ctx.ID().getText(), target != null ? this.clean(target.getText()) : null, options).multiple(separator);
    }

    private String[] options(List<ItrParser.OptionContext> options) {
        return (String[])options.stream().map(o -> o.getText().substring(1)).toArray(String[]::new);
    }

    private String calculateExpressionIndent(ItrParser.ExpressionContext ctx) {
        CharStream inputStream = ctx.start.getInputStream();
        int lnIndex = ctx.start.getStartIndex() - ctx.start.getCharPositionInLine();
        String text = inputStream.getText(new Interval(lnIndex, ctx.start.getStartIndex() - 1)).substring(1);
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder indent = new StringBuilder();
        for (int i = 0; text.length() > i && text.charAt(i) == '\t'; ++i) {
            indent.append("\t");
        }
        return indent.toString();
    }

    private String[] clean(String text) {
        return text.substring(1, text.length() - 1).split("\\.");
    }

    private String format(String separator) {
        String s = separator.substring(1, separator.length() - 1);
        return s.replace(NL_SEPARATOR, "\n").replace(TAB_SEPARATOR, "\t").replace("~", "");
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        this.logger.log("Error reading template. Template not well formed: " + node.getText() + "\n\n", new Object[0]);
    }
}

