/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services.servlets;

import io.intino.icod.OutputMessage;
import io.intino.icod.core.MimeTypes;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;

public class HttpOutputMessage
implements OutputMessage {
    protected final HttpServletResponse response;

    public HttpOutputMessage(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void write(String content) {
        try {
            PrintWriter out = this.response.getWriter();
            this.response.setHeader("Access-Control-Allow-Origin", "*");
            this.response.setContentType("text/plain");
            this.response.setCharacterEncoding("utf-8");
            out.println(content);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(File file) {
        try {
            byte[] content = this.readFile(file);
            this.response.setContentType(MimeTypes.getInstance().getFromFile(file));
            this.response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            this.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(byte[] content) {
        try {
            this.response.setContentLength(content.length);
            this.response.getOutputStream().write(content);
            this.response.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(String filename, byte[] content) {
        this.response.setContentType(MimeTypes.getInstance().getFromFilename(filename));
        this.response.setHeader("Content-Disposition", "attachment; filename=" + filename);
        this.write(content);
    }

    private byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }
}

