/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services.context;

import io.intino.alexandria.http.server.AlexandriaHttpRequest;
import io.intino.icod.core.StreamHelper;
import io.intino.icod.services.context.AlexandriaInputMessage;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class BodyInputMessage
extends AlexandriaInputMessage {
    private HashMap<String, String> parameters;

    public BodyInputMessage(AlexandriaHttpRequest request) {
        super(request);
    }

    @Override
    protected String getParameter(String name) {
        try {
            this.readParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.parameters.containsKey(name) ? this.parameters.get(name) : null;
    }

    private Map<String, String> readParameters() throws IOException {
        String[] urlParams;
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = new HashMap();
        ByteArrayOutputStream rawData = this.rawData(this.request.raw());
        for (String param : urlParams = new String(rawData.toByteArray()).split("&")) {
            int equalsPos = param.indexOf(61);
            if (equalsPos == -1) continue;
            this.parameters.put(param.substring(0, equalsPos), param.substring(equalsPos + 1));
        }
        Enumeration parameterNames = this.request.raw().getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.parameters.put(name, this.request.raw().getParameter(name));
        }
        return this.parameters;
    }

    private ByteArrayOutputStream rawData(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream rawData = new ByteArrayOutputStream();
        StreamHelper.copyData((InputStream)request.getInputStream(), rawData);
        return rawData;
    }
}

