/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services.context;

import io.intino.alexandria.http.server.AlexandriaHttpResponse;
import io.intino.icod.OutputMessage;
import io.intino.icod.core.MimeTypes;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;

public class AlexandriaOutputMessage
implements OutputMessage {
    protected final AlexandriaHttpResponse response;

    public AlexandriaOutputMessage(AlexandriaHttpResponse response) {
        this.response = response;
    }

    @Override
    public void write(String content) {
        try {
            HttpServletResponse raw = this.response.raw();
            PrintWriter out = raw.getWriter();
            raw.setHeader("Access-Control-Allow-Origin", "*");
            raw.setContentType("text/plain");
            raw.setCharacterEncoding("utf-8");
            out.println(content);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(File file) {
        try {
            byte[] content = this.readFile(file);
            HttpServletResponse raw = this.response.raw();
            raw.setContentType(MimeTypes.getInstance().getFromFile(file));
            raw.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            this.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(byte[] content) {
        try {
            HttpServletResponse raw = this.response.raw();
            raw.setContentLength(content.length);
            raw.getOutputStream().write(content);
            raw.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(String filename, byte[] content) {
        HttpServletResponse raw = this.response.raw();
        raw.setContentType(MimeTypes.getInstance().getFromFilename(filename));
        raw.setHeader("Content-Disposition", "attachment; filename=" + filename);
        this.write(content);
    }

    private byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }
}

