/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services;

import io.intino.icod.Configuration;
import io.intino.icod.InputMessage;
import io.intino.icod.OutputMessage;
import io.intino.icod.core.ErrorManager;
import io.intino.icod.core.StreamHelper;
import io.intino.icod.services.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

public class RetrieveService
extends Service
implements io.intino.icod.RetrieveService {
    @Override
    public void retrieve(InputMessage input, OutputMessage output) {
        try {
            Configuration configuration = this.loadConfiguration(input, output);
            logger.info("Checking parameters");
            this.checkOperation(input, "get", output);
            this.checkSyntaxVersion(input, output);
            this.checkId(input, output);
            logger.info("Request for loading file with id: " + input.getId());
            File file = this.repository(configuration).getSignature(input.getId());
            if (!file.exists()) {
                output.write(ErrorManager.genError("ERR-06", null));
                return;
            }
            this.checkIsFile(file, input, output);
            this.checkCanReadFile(file, input, output);
            this.checkIsExpired(file, input, output, configuration);
            this.writeOutput(file, input, output, configuration);
            this.removeFile(file, input, configuration);
            this.repository(configuration).cleanExpiredSignatures();
            this.repository(configuration).cleanDocuments();
            logger.info(String.format("File %s recovered", configuration.getSignaturesDirectory() + "/" + input.getId()));
        }
        catch (IOException e) {
            this.throwFailure("ERR-07", output);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(File file, InputMessage input, OutputMessage output, Configuration configuration) throws IOException, GeneralSecurityException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            output.write(new String(StreamHelper.readBytes(stream), "UTF-8"));
        }
        catch (Throwable throwable) {
            StreamHelper.close(stream);
            throw throwable;
        }
        StreamHelper.close(stream);
    }

    private void checkIsFile(File file, InputMessage input, OutputMessage output) throws IOException {
        if (file.isFile()) {
            return;
        }
        this.removeFile(file, input, this.loadConfiguration(input, output));
        logger.warning(String.format("File with identifier %s is not a valid file", input.getId()));
        this.throwFailure(ErrorManager.genError("ERR-06", null), output);
    }

    private void checkCanReadFile(File file, InputMessage input, OutputMessage output) throws IOException {
        if (file.canRead()) {
            return;
        }
        this.removeFile(file, input, this.loadConfiguration(input, output));
        logger.warning(String.format("Cant read file with identifier %s", input.getId()));
        this.throwFailure(ErrorManager.genError("ERR-06", null), output);
    }

    private void checkIsExpired(File file, InputMessage input, OutputMessage output, Configuration configuration) throws IOException {
        if (!this.repository(configuration).isSignatureExpired(input.getId())) {
            return;
        }
        this.removeFile(file, input, this.loadConfiguration(input, output));
        logger.warning(String.format("File with identifier %s is expired", input.getId()));
        this.throwFailure(ErrorManager.genError("ERR-06", null), output);
    }

    private void removeFile(File file, InputMessage input, Configuration configuration) {
        if (!file.exists()) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        file.delete();
    }
}

