/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.core;

import io.intino.icod.Configuration;
import io.intino.icod.DocumentManager;
import io.intino.icod.core.StreamHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Function;
import org.apache.tika.io.IOUtils;

public class ServerDocumentManager
implements DocumentManager {
    private final Configuration configuration;

    public ServerDocumentManager(Configuration configuration) {
        this.configuration = configuration;
        this.checkSignaturesDirectory();
    }

    private void checkSignaturesDirectory() {
        File signaturesDirectory = new File(this.configuration.getSignaturesDirectory());
        if (!signaturesDirectory.exists()) {
            signaturesDirectory.mkdirs();
        }
    }

    @Override
    public InputStream getClientApplicationResource(String operatingSystem) {
        String clientApplicationFilename = this.configuration.getClientApplicationFilename(operatingSystem);
        return ServerDocumentManager.class.getResourceAsStream("/" + clientApplicationFilename);
    }

    @Override
    public File getRepositoryDocument(String key) {
        return new File(this.configuration.getRepositoryDirectory() + "/" + key);
    }

    public void putRepositoryDocument(String key, InputStream content) throws IOException {
        File document = new File(this.configuration.getRepositoryDirectory() + "/" + key);
        document.getParentFile().mkdirs();
        Files.write(document.toPath(), IOUtils.toByteArray((InputStream)content), new OpenOption[0]);
    }

    public boolean existsRepositoryDocument(String key) {
        File repositoryDirectory = new File(this.configuration.getRepositoryDirectory());
        return this.getRepositoryDocument(key).getParent().equals(repositoryDirectory.getAbsolutePath());
    }

    @Override
    public File getSignature(String key) {
        return new File(this.configuration.getSignaturesDirectory(), key);
    }

    @Override
    public void putSignature(String key, byte[] signature) throws IOException {
        this.saveFile(new File(this.configuration.getSignaturesDirectory(), key), signature);
    }

    @Override
    public boolean isSignatureExpired(String key) {
        if (this.existsRepositoryDocument(key)) {
            return false;
        }
        File file = this.getSignature(key);
        return System.currentTimeMillis() - file.lastModified() > this.configuration.getSignaturesExpirationTime();
    }

    public boolean isDocumentExpired(String key) {
        if (this.existsRepositoryDocument(key)) {
            return false;
        }
        File file = this.getRepositoryDocument(key);
        return System.currentTimeMillis() - file.lastModified() > 3600000L;
    }

    @Override
    public void cleanExpiredSignatures() {
        this.cleanExpiredFiles(new File(this.configuration.getSignaturesDirectory()), file -> this.isSignatureExpired(file.toPath().toString()));
    }

    @Override
    public void cleanDocuments() {
        this.cleanExpiredFiles(new File(this.configuration.getRepositoryDirectory()), file -> this.isDocumentExpired(file.toPath().toString()));
    }

    public void cleanExpiredFiles(File directory, Function<File, Boolean> expiredChecker) {
        if (!directory.exists()) {
            return;
        }
        for (File file : directory.listFiles()) {
            try {
                if (!file.exists() || !file.isFile() || !expiredChecker.apply(file).booleanValue()) continue;
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(File file, byte[] content) throws IOException {
        ByteArrayInputStream signatureStream = new ByteArrayInputStream(content);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamHelper.copyData(signatureStream, fileOutputStream);
        }
        finally {
            StreamHelper.close(signatureStream);
        }
    }
}

