/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class LibraryFile {
    public static String getExtension(String sFilename) {
        Integer iPos = sFilename.lastIndexOf(".");
        if (iPos == -1) {
            return null;
        }
        return sFilename.substring(iPos + 1);
    }

    public static String getContentType(File file) {
        try {
            return LibraryFile.getContentType(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return "application/octet-stream";
        }
    }

    public static String getContentType(InputStream inputStream) {
        String contentType = "application/octet-stream";
        BodyContentHandler contentHandler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try {
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(inputStream, (ContentHandler)contentHandler, metadata, new ParseContext());
            contentType = metadata.get("Content-Type");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return contentType;
    }
}

