/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services.servlets;

import io.intino.icod.InputMessage;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;

public abstract class HttpInputMessage
implements InputMessage {
    protected final HttpServletRequest request;

    public HttpInputMessage(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getId() {
        return this.getParameter("id");
    }

    @Override
    public String getOperation() {
        return this.getParameter("op");
    }

    @Override
    public String getSyntaxVersion() {
        return this.getParameter("v");
    }

    @Override
    public String getData() {
        return this.getParameter("dat");
    }

    @Override
    public String getSignature() {
        return this.getParameter("sig");
    }

    @Override
    public String getAppName() {
        return this.request.getSession().getServletContext().getServletContextName();
    }

    public String getCertificate() {
        return this.getParameter("cert");
    }

    public String getAlgorithm() {
        return this.getParameter("algo");
    }

    public String getFormat() {
        return this.getParameter("format");
    }

    public String getDesKey() {
        return "12345678";
    }

    public String getDocumentId() {
        return this.getParameter("doc");
    }

    public String getSessionData() {
        return this.getParameter("session");
    }

    public String getExtraParams() {
        return this.getParameter("params");
    }

    @Override
    public boolean downloadApp() {
        return this.request.getRequestURL().toString().contains("/app");
    }

    @Override
    public String getOperatingSystem() {
        return this.getParameter("os");
    }

    public boolean storeSignedPdf() {
        return this.request.getRequestURL().toString().contains("/store-signed-pdf");
    }

    @Override
    public String getRetrieveUrl() {
        return this.getBaseUrl() + "/retrieve";
    }

    public String getSignedPdfStorageUrl() {
        return this.getBaseUrl() + "/store-signed-pdf";
    }

    @Override
    public String getDownloadFileUrl(File file) {
        return this.getBaseUrl() + "/file?id=" + String.valueOf(file.toPath().getFileName());
    }

    private String getBaseUrl() {
        String url = this.request.getRequestURL().toString();
        return url.substring(0, url.lastIndexOf("/"));
    }

    protected abstract String getParameter(String var1);

    protected static class Parameter {
        protected static final String Operation = "op";
        protected static final String Id = "id";
        protected static final String SyntaxVersion = "v";
        protected static final String Data = "dat";
        protected static final String Signature = "sig";
        protected static final String Certificate = "cert";
        protected static final String Algorithm = "algo";
        protected static final String Format = "format";
        protected static final String Document = "doc";
        protected static final String SessionData = "session";
        protected static final String ExtraParams = "params";
        protected static final String OperatingSystem = "os";

        protected Parameter() {
        }
    }
}

