/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services;

import io.intino.icod.Configuration;
import io.intino.icod.InputMessage;
import io.intino.icod.OutputMessage;
import io.intino.icod.core.ErrorManager;
import io.intino.icod.core.StreamHelper;
import io.intino.icod.services.Service;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class StorageService
extends Service
implements io.intino.icod.StorageService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(InputMessage input, OutputMessage output) {
        OutputStream fos = null;
        String id = null;
        boolean stored = true;
        try {
            logger.info("Checking parameters");
            this.checkOperation(input, "put", output);
            this.checkSyntaxVersion(input, output);
            this.checkId(input, output);
            this.checkData(input, output);
            id = input.getId();
            logger.info("Request for saving file with id: " + id);
            byte[] signature = this.parseData(input);
            if (signature != null) {
                Configuration configuration = this.loadConfiguration(input, output);
                this.repository(configuration).putSignature(input.getId(), signature);
            } else {
                stored = false;
            }
        }
        catch (IOException e) {
            stored = false;
        }
        finally {
            StreamHelper.close(fos);
        }
        if (!stored) {
            logger.severe("Request for saving file " + id + " FAILURE");
        } else {
            logger.info("Request for saving file " + id + " FINISHED");
        }
        output.write(stored ? "OK" : ErrorManager.genError("ERR-18", null));
        return true;
    }

    private byte[] parseData(InputMessage input) {
        return input.getData().getBytes();
    }

    protected String checkData(final InputMessage input, OutputMessage output) throws IOException {
        String data = input.getData();
        if (data != null) {
            return data;
        }
        InputMessage inputWhenError = new InputMessage(){

            @Override
            public String getId() {
                return input.getId();
            }

            @Override
            public String getOperation() {
                return input.getOperation();
            }

            @Override
            public String getSyntaxVersion() {
                return input.getSyntaxVersion();
            }

            @Override
            public String getData() {
                return ErrorManager.genError("ERR-02", null);
            }

            @Override
            public String getSignature() {
                return input.getSignature();
            }

            @Override
            public String getAppName() {
                return input.getAppName();
            }

            @Override
            public String getRetrieveUrl() {
                return input.getRetrieveUrl();
            }

            @Override
            public boolean downloadApp() {
                return input.downloadApp();
            }

            @Override
            public String getOperatingSystem() {
                return input.getOperatingSystem();
            }

            @Override
            public String getDownloadFileUrl(File file) {
                return input.getDownloadFileUrl(file);
            }
        };
        this.store(inputWhenError, output);
        this.throwFailure("ERR-02", output);
        return null;
    }
}

