/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services;

import com.google.gson.Gson;
import io.intino.icod.InputMessage;
import io.intino.icod.OutputMessage;
import io.intino.icod.core.ErrorManager;
import io.intino.icod.core.SignatureInfo;
import io.intino.icod.core.XadesSignatureHelper;
import io.intino.icod.services.Service;

public class SignatureService
extends Service
implements io.intino.icod.SignatureService {
    @Override
    public void parseSignature(InputMessage input, OutputMessage output) {
        logger.info("Checking parameters");
        this.checkSignature(input, output);
        SignatureInfo info = new XadesSignatureHelper().getInfo(input.getSignature());
        output.write(new Gson().toJson((Object)info));
    }

    private void checkSignature(InputMessage input, OutputMessage output) {
        if (input.getSignature() != null) {
            return;
        }
        logger.warning(String.format("Signature not found", input.getId()));
        this.throwFailure(ErrorManager.genError("ERR-21", null), output);
    }
}

