/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.core;

import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.ValidarFirmaXML;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.javasign.ts.TimeStampValidator;
import es.mityc.javasign.tsa.ITimeStampValidator;
import io.intino.icod.core.SignatureHelper;
import io.intino.icod.core.SignatureInfo;
import java.io.ByteArrayInputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.monet.encrypt.extractor.CertificateExtractor;
import org.monet.encrypt.extractor.ExtractorUser;
import org.w3c.dom.Document;

public class XadesSignatureHelper
implements SignatureHelper {
    @Override
    public SignatureInfo getInfo(String signature) {
        try {
            ExtractorUser user = this.extractInfoFrom(this.certificateOf(signature));
            return this.infoOf(user);
        }
        catch (FirmaXMLError firmaXMLError) {
            return null;
        }
    }

    @Override
    public X509Certificate getCertificate(String signature) {
        try {
            return this.certificateOf(signature);
        }
        catch (FirmaXMLError firmaXMLError) {
            return null;
        }
    }

    private X509Certificate certificateOf(String signature) throws FirmaXMLError {
        Document documentSignature = this.signatureDocumentOf(signature);
        ResultadoValidacion result = this.loadSignature(documentSignature);
        if (!result.isValidate()) {
            return null;
        }
        return (X509Certificate)result.getDatosFirma().getCadenaFirma().getCertificates().get(0);
    }

    private Document signatureDocumentOf(String signature) {
        try {
            String xmlSignature = new String(Base64.decodeBase64((String)signature), "UTF-8");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new ByteArrayInputStream(xmlSignature.getBytes()));
        }
        catch (Exception e) {
            return null;
        }
    }

    private ResultadoValidacion loadSignature(Document documentSignature) throws FirmaXMLError {
        ValidarFirmaXML vXml = new ValidarFirmaXML();
        ArrayList results = vXml.validar(documentSignature, "./", null, (ITimeStampValidator)new TimeStampValidator());
        return (ResultadoValidacion)results.get(0);
    }

    private ExtractorUser extractInfoFrom(X509Certificate certificate) {
        CertificateExtractor extractor = new CertificateExtractor();
        return extractor.extractUser(certificate);
    }

    private SignatureInfo infoOf(ExtractorUser user) {
        return new SignatureInfo(user.getUsername(), user.getFullname(), user.getEmail());
    }
}

