/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.core;

import java.util.Dictionary;
import java.util.Hashtable;

public final class ErrorManager {
    private static final String ERROR_NUMBER = "%#%";
    private static final String ERROR_MESSAGE = "%MSG%";
    private static final String ERROR_TEMPLATE = "%#%:=%MSG%";
    private static final String GENERIC_ERROR = "Error generico";
    public static final String ERROR_MISSING_OPERATION_NAME = "ERR-00";
    public static final String ERROR_UNSUPPORTED_OPERATION_NAME = "ERR-01";
    public static final String ERROR_MISSING_DATA = "ERR-02";
    public static final String ERROR_BAD_XML = "ERR-03";
    public static final String ERROR_BAD_CERTIFICATE = "ERR-04";
    public static final String ERROR_MISSING_DATA_ID = "ERR-05";
    public static final String ERROR_INVALID_DATA_ID = "ERR-06";
    public static final String ERROR_INVALID_DATA = "ERR-07";
    public static final String ERROR_MISSING_SERVLET = "ERR-08";
    public static final String ERROR_INVALID_SERVLET = "ERR-09";
    public static final String ERROR_NOT_SUPPORTED_FORMAT = "ERR-10";
    public static final String ERROR_CANCELLED_OPERATION = "ERR-11";
    public static final String ERROR_CODING_BASE64 = "ERR-12";
    public static final String ERROR_PKE = "ERR-13";
    public static final String ERROR_SIGNING = "ERR-14";
    public static final String ERROR_INVALID_CIPHER_KEY = "ERR-15";
    public static final String ERROR_CIPHERING = "ERR-16";
    public static final String ERROR_NO_CERT_SELECTED = "ERR-17";
    public static final String ERROR_COMMUNICATING_WITH_WEB = "ERR-18";
    public static final String ERROR_CONFIGURATION_FILE_PROBLEM = "ERR-19";
    public static final String ERROR_MISSING_SYNTAX_VERSION = "ERR-20";
    public static final String SIANI_ERROR_MISSING_SIGNATURE = "ERR-21";
    private static final Dictionary<String, String> ERRORS = new Hashtable<String, String>();

    private ErrorManager() {
    }

    public static String genError(String number, String msg) {
        return ERROR_TEMPLATE.replace(ERROR_NUMBER, number).replace(ERROR_MESSAGE, msg != null ? msg : (ERRORS.get(number) != null ? (CharSequence)ERRORS.get(number) : GENERIC_ERROR));
    }

    static {
        ERRORS.put(ERROR_MISSING_OPERATION_NAME, "No se ha indicado codigo de operacion");
        ERRORS.put(ERROR_UNSUPPORTED_OPERATION_NAME, "Codigo de operacion no soportado");
        ERRORS.put(ERROR_MISSING_DATA, "No se han proporcionado los datos de la operacion");
        ERRORS.put(ERROR_BAD_XML, "Se ha recibido un XML mal formado");
        ERRORS.put(ERROR_BAD_CERTIFICATE, "Se ha recibido un certificado corrupto");
        ERRORS.put(ERROR_MISSING_DATA_ID, "No se ha proporcionado un identificador para los datos");
        ERRORS.put(ERROR_INVALID_DATA_ID, "El identificador para los datos es invalido");
        ERRORS.put(ERROR_INVALID_DATA, "Los datos solicitados o enviados son invalidos");
        ERRORS.put(ERROR_MISSING_SERVLET, "No se ha proporcionado el sevlet para la comunicacion de los datos");
        ERRORS.put(ERROR_INVALID_SERVLET, "La ruta del servlet es invalida");
        ERRORS.put(ERROR_NOT_SUPPORTED_FORMAT, "Se ha configurado un formato de firma no soportado");
        ERRORS.put(ERROR_CANCELLED_OPERATION, "Operaci\u00f3n cancelada");
        ERRORS.put(ERROR_CODING_BASE64, "Error en la codificaci\u00f3n del base 64");
        ERRORS.put(ERROR_PKE, "No se seleccion\u00f3 certificado de firma");
        ERRORS.put(ERROR_SIGNING, "Ocurri\u00f3 un error en la operaci\u00f3n de firma");
        ERRORS.put(ERROR_INVALID_CIPHER_KEY, "La clave de cifrado proporcionada no es valida");
        ERRORS.put(ERROR_CIPHERING, "Error durante el proceso de cifrado de los datos");
        ERRORS.put(ERROR_NO_CERT_SELECTED, "El usuario no seleccion\u00f3 ning\u00fan certificado ");
        ERRORS.put(ERROR_COMMUNICATING_WITH_WEB, "No se ha podido enviar la firma generada a la web de origen");
        ERRORS.put(ERROR_CONFIGURATION_FILE_PROBLEM, "Error de configuraci\u00f3n de la aplicaci\u00f3n");
        ERRORS.put(ERROR_MISSING_SYNTAX_VERSION, "No se ha indicado la versi\u00f3n de la sintaxis de la operaci\u00f3n");
        ERRORS.put(SIANI_ERROR_MISSING_SIGNATURE, "No se ha indicado la firma digital");
    }
}

