import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import DisplaysRolesTableRow from "unit-elements/gen/displays/rows/RolesTableRow";
import DisplaysRolesTableUserItem from "unit-elements/gen/displays/items/RolesTableUserItem";
import DisplaysRolesTableDefinitionItem from "unit-elements/gen/displays/items/RolesTableDefinitionItem";
import DisplaysRolesTableTypeItem from "unit-elements/gen/displays/items/RolesTableTypeItem";
import DisplaysRolesTableNatureItem from "unit-elements/gen/displays/items/RolesTableNatureItem";
import DisplaysRolesTableStartDateItem from "unit-elements/gen/displays/items/RolesTableStartDateItem";
import DisplaysRolesTableEndDateItem from "unit-elements/gen/displays/items/RolesTableEndDateItem";
import DisplaysRolesTableOperationsItem from "unit-elements/gen/displays/items/RolesTableOperationsItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import RolesTableCatalogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import RolesTableCatalogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class RolesTableCatalog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new RolesTableCatalogNotifier(this);
		this.requester = new RolesTableCatalogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height={this.fixHeight != null ? this.fixHeight("100.0%") : "100.0%"} style={{...this.props.style,...display}}>
				<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831" format="bordered" noItemsMessage="No roles" pageSize={20} itemHeight={50} scrollingMark={false} selection="single">
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_1408578658" style={{width:"25%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_1408578658.a_718271056" mode="normal" translate={true} value="User">
						</UiText>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a1010077361" style={{width:"20%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a1010077361.a_928349181" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a1010077361.a_928349181.a1695928932" mode="normal" translate={true} value="Class">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a1728660333" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a1728660333.a1088916710" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a1728660333.a1088916710.a_1989519733" mode="normal" translate={true} value="Type">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_400058781" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_400058781.a564333513" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_400058781.a564333513.a_1652681288" mode="normal" translate={true} value="Nature">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_485778542" style={{width:"15%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_485778542.a523573816" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_485778542.a523573816.a2031433643" mode="normal" translate={true} value="Start date">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_133705834" style={{width:"15%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_133705834.a_1676003239" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_133705834.a_1676003239.a512461233" mode="normal" translate={true} value="End date">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863333831.a_344742116" style={{width:"5%",paddingRight:"10px"}} hidden="Never">
					</UiHeading>
				</UiTable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(RolesTableCatalog));
DisplayFactory.register("RolesTableCatalog", withStyles(styles, { withTheme: true })(withSnackbar(RolesTableCatalog)));