import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import DisplaysNodeRevisionsTableRow from "unit-elements/gen/displays/rows/NodeRevisionsTableRow";
import DisplaysNodeRevisionsTableLabelItem from "unit-elements/gen/displays/items/NodeRevisionsTableLabelItem";
import DisplaysNodeRevisionsTableOperationsItem from "unit-elements/gen/displays/items/NodeRevisionsTableOperationsItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NodeRevisionsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NodeRevisionsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NodeRevisionsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NodeRevisionsTemplateNotifier(this);
		this.requester = new NodeRevisionsTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height={this.fixHeight != null ? this.fixHeight("100.0%") : "100.0%"} style={{...this.props.style,...display}}>
				<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249683110" format="bordered" noItemsMessage="No hay versiones del elemento registradas" pageSize={20} itemHeight={50} scrollingMark={false} selection="single">
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249683110.a_1759233023" style={{width:"80%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249683110.a_1759233023.a_142429872" mode="normal" value="Título">
						</UiText>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249683110.a1914553990" style={{width:"20%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249683110.a1914553990.a1264159377" layout="horizontal endjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249683110.a1914553990.a1264159377.a1627389971" mode="normal" value="Operaciones">
							</UiText>
						</UiBlock>
					</UiHeading>
				</UiTable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NodeRevisionsTemplate));
DisplayFactory.register("NodeRevisionsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(NodeRevisionsTemplate)));