import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDashboardMetabase from "alexandria-ui-elements/src/displays/components/DashboardMetabase";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DashboardTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DashboardTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DashboardTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DashboardTemplateNotifier(this);
		this.requester = new DashboardTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="smallAir" layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_334275555" format="headerSpaced" layout="horizontal">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_334275555.a_298001228" layout="vertical flexible">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_334275555.a_298001228.a2107653245" layout="horizontal">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_334275555.a_298001228.a2107653245.a_1333751337" format="bold h4" mode="normal" translate={true} value="Dashboard">
							</UiText>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1364115916" format="smallAirTop" layout="horizontal flexible">
					<UiDashboardMetabase context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1364115916.a_1493539984" width="100.0%" height="100.0%">
					</UiDashboardMetabase>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate));
DisplayFactory.register("DashboardTemplate", withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate)));