/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.pages;

import com.adobe.xmp.impl.Base64;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.goros.unit.box.I18n;
import io.intino.goros.unit.box.ui.displays.templates.GorosAppTemplate;
import io.intino.goros.unit.box.ui.pages.AbstractBannerPage;
import io.intino.goros.unit.util.Formatters;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.monet.space.kernel.Kernel;
import org.monet.space.kernel.components.ComponentFederation;
import org.monet.space.kernel.exceptions.DataException;
import org.monet.space.kernel.model.Banner;

public class BannerPage
extends AbstractBannerPage {
    public String view;
    private static final String NoInfo = "<html><head><link type=\"text/css\" rel=\"stylesheet\" href=\"https://fonts.googleapis.com/css?family=Roboto:300\"></head><body><div>No information available</div></body></html>";

    @Override
    public String execute() {
        try {
            String content = IOUtils.toString((InputStream)BannerPage.class.getResourceAsStream("/banner.tpl"), (String)"UTF-8");
            return this.replaceMarks(content);
        }
        catch (IOException e) {
            return NoInfo;
        }
    }

    private String replaceMarks(String content) {
        Banner banner = ComponentFederation.getInstance().getDefaultLayer().loadBanner();
        String language = this.session.discoverLanguage();
        String activeTasksMessage = Formatters.countMessage(banner.getCountActiveTasks(), I18n.translate("active task", language), I18n.translate("active tasks", language));
        String pendingTasksMessage = Formatters.countMessage(banner.getCountAliveTasks(), I18n.translate("pending task", language), I18n.translate("pending tasks", language));
        String noPermissionsMessage = I18n.translate("Restricted information", language);
        content = content.replace("::view::", this.view != null ? this.view : "minimal");
        content = content.replace("::title::", banner.getTitle());
        content = content.replace("::subtitle::", banner.getSubTitle());
        content = content.replace("::activeTasksMessage::", activeTasksMessage);
        content = content.replace("::pendingTasksMessage::", pendingTasksMessage);
        content = content.replace("::noPermissionsMessage::", noPermissionsMessage);
        content = content.replace("::hasPermissions::", String.valueOf(banner.hasPermissions()));
        content = content.replace("::noHasPermissions::", String.valueOf(!banner.hasPermissions()));
        content = content.replace("::gotoSpace::", I18n.translate("goto space", language));
        if (banner.getSpaceUrl() != null) {
            content = content.replace("::spaceUrl::", banner.getSpaceUrl());
        }
        content = content.replace("::logo::", this.imageSourceOf(this.logo()));
        return content;
    }

    public Soul prepareSoul(UIClient client) {
        return new Soul(this.session){

            public void personify() {
                GorosAppTemplate component = new GorosAppTemplate(BannerPage.this.box);
                this.register((Display)component);
                component.init();
            }
        };
    }

    private String imageSourceOf(InputStream logo) {
        try {
            return "data:image;base64," + new String(Base64.encode((byte[])logo.readAllBytes()));
        }
        catch (IOException e) {
            return "";
        }
    }

    private InputStream logo() {
        try {
            return new File(Kernel.getInstance().getConfiguration().getFederationLogoFile()).toURI().toURL().openStream();
        }
        catch (IOException | DataException ignored) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }
}

