/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTasksToolbarTemplate;
import java.util.function.Consumer;

public class TasksToolbarTemplate
extends AbstractTasksToolbarTemplate<UnitBox> {
    private Consumer<Boolean> refreshListener;
    private boolean refreshToolbarVisible = false;

    public TasksToolbarTemplate(UnitBox box) {
        super(box);
    }

    public TasksToolbarTemplate onRefresh(Consumer<Boolean> listener) {
        this.refreshListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.refresh.onExecute(e -> this.refreshAndHide());
        ((UnitBox)this.box()).notifier().onTaskCreated((Display)this, task -> this.showRefreshToolbar());
    }

    @Override
    public void remove() {
        super.remove();
        ((UnitBox)this.box()).notifier().unTaskCreated((Display)this);
    }

    private void showRefreshToolbar() {
        if (this.refreshToolbarVisible) {
            return;
        }
        this.refreshToolbar.visible(true);
        this.refreshToolbarVisible = true;
    }

    private void refreshAndHide() {
        this.refreshToolbar.visible(false);
        this.refreshToolbarVisible = false;
        if (this.refreshListener != null) {
            this.refreshListener.accept(true);
        }
    }
}

