/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskPlaceWaitTemplate;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.TaskHelper;
import java.time.Instant;
import java.util.Date;
import org.monet.metamodel.PlaceActionProperty;
import org.monet.metamodel.WaitActionProperty;
import org.monet.metamodel.internal.Time;
import org.monet.space.kernel.machines.ttm.behavior.ProcessBehavior;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.Task;

public class TaskPlaceWaitTemplate
extends AbstractTaskPlaceWaitTemplate<UnitBox> {
    private Task task;
    private WaitActionProperty property;

    public TaskPlaceWaitTemplate(UnitBox box) {
        super(box);
    }

    public TaskPlaceWaitTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskPlaceWaitTemplate property(WaitActionProperty property) {
        this.property = property;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.plusHour.onExecute(e -> this.plusHour());
        this.plusDay.onExecute(e -> this.plusDay());
        this.plusMonth.onExecute(e -> this.plusMonth());
        this.plusYear.onExecute(e -> this.plusYear());
        this.freePlace.onExecute(e -> this.freePlace());
    }

    public void refresh() {
        super.refresh();
        this.label.value(Language.getInstance().getModelResource(this.property.getLabel()));
        long dueDate = this.dueDate();
        this.refreshDescription(dueDate);
        this.refreshOptions(dueDate);
    }

    private void refreshDescription(long dueDate) {
        this.description.value((String)(dueDate != -1L ? this.translate("Due date is") + " " + Formatters.shortDate(Instant.ofEpochMilli(dueDate)) : this.translate("Due date not defined")));
    }

    private void refreshOptions(long dueDate) {
        this.plusHour.title(dueDate != -1L ? this.translate("pospone one hour") : this.translate("define for next hour"));
        this.plusHour.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        this.plusDay.title(dueDate != -1L ? this.translate("pospone one day") : this.translate("define for next day"));
        this.plusDay.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        this.plusMonth.title(dueDate != -1L ? this.translate("pospone one month") : this.translate("define for next month"));
        this.plusMonth.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        this.plusYear.title(dueDate != -1L ? this.translate("pospone one year") : this.translate("define for next year"));
        this.plusYear.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        this.freePlace.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
    }

    private void plusHour() {
        this.plusHour.readonly(true);
        this.setup(this.plusMillis(TaskHelper.hoursToMillis(1)));
        this.plusHour.readonly(false);
    }

    private void plusDay() {
        this.plusDay.readonly(true);
        this.setup(this.plusMillis(TaskHelper.daysToMillis(1)));
        this.plusDay.readonly(false);
    }

    private void plusMonth() {
        this.plusMonth.readonly(true);
        this.setup(this.plusMillis(TaskHelper.monthsToMillis(1)));
        this.plusMonth.readonly(false);
    }

    private void plusYear() {
        this.plusYear.readonly(true);
        this.setup(this.plusMillis(TaskHelper.yearsToMillis(1)));
        this.plusYear.readonly(false);
    }

    private long plusMillis(long millis) {
        long timer = this.dueDate();
        if (timer == -1L) {
            timer = Instant.now().toEpochMilli();
        }
        return timer + millis;
    }

    private void freePlace() {
        this.freePlace.readonly(true);
        this.setup(0L);
        this.freePlace.readonly(false);
    }

    private long dueDate() {
        ProcessBehavior process = this.task.getProcess();
        return process.getTimerDue(process.getCurrentPlace().getCode());
    }

    private void setup(long newTimer) {
        long currentTimestamp = Instant.now().toEpochMilli();
        long timeout = newTimer - currentTimestamp;
        this.task.getProcess().setupWaitAction(new Date(currentTimestamp), new Time(timeout > 0L ? timeout : 0L));
        this.refresh();
    }
}

