/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.MimeTypes;
import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.File;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.server.UIFile;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeDocumentTemplate;
import io.intino.goros.unit.util.NodeHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.monet.space.kernel.components.ComponentDocuments;
import org.monet.space.kernel.exceptions.SystemException;
import org.monet.space.kernel.model.Node;

public class NodeDocumentTemplate
extends AbstractNodeDocumentTemplate<UnitBox> {
    private Node node;
    private boolean readonly;
    private Resource newDocumentResource = null;

    public NodeDocumentTemplate(UnitBox box) {
        super(box);
    }

    public NodeDocumentTemplate node(Node node) {
        this.node = node;
        return this;
    }

    public NodeDocumentTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.editDocumentDialog.onOpen(e -> {
            this.stepper.select(0);
            this.save.readonly(true);
            this.newDocumentResource = null;
        });
        this.editingStep.canNext(step -> this.newDocumentResource != null);
        this.downloadDocument.onExecute(e -> this.downloadDocument());
        this.newDocument.onChange(e -> this.updateNewDocument((Resource)e.value()));
        this.save.onExecute(e -> this.replaceDocument());
    }

    public void refresh() {
        super.refresh();
        this.edit.visible(!this.readonly);
        this.toggleDocumentDialog();
        this.refreshPreview();
    }

    private void toggleDocumentDialog() {
        if (this.readonly && this.editDocumentDialog.isVisible()) {
            this.editDocumentDialog.close();
        } else if (!this.readonly && !this.editDocumentDialog.isVisible()) {
            this.editDocumentDialog.open();
        }
    }

    private UIFile downloadDocument() {
        this.stepper.next();
        return new UIFile(){

            public String label() {
                return NodeDocumentTemplate.this.node.getLabel() + MimeTypes.extensionOf((String)ComponentDocuments.getInstance().getDocumentContentType(NodeDocumentTemplate.this.node.getId()));
            }

            public InputStream content() {
                try {
                    return ComponentDocuments.getInstance().getDocumentContent(NodeDocumentTemplate.this.node.getId());
                }
                catch (SystemException ex) {
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
        };
    }

    private void updateNewDocument(Resource value) {
        this.newDocumentResource = value;
        this.save.readonly(false);
        this.stepper.next();
    }

    private void replaceDocument() {
        try {
            ComponentDocuments.getInstance().uploadDocument(this.node.getId(), this.newDocumentResource.stream(), this.newDocumentResource.metadata().contentType(), true);
            this.editDocumentDialog.close();
            this.editDocumentDialog.notifyUser(this.translate("Document saved successfully"), UserMessage.Type.Success);
            this.refreshPreview();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void refreshPreview() {
        this.preview.value(this.file());
    }

    private File file() {
        File result = new File();
        result.filename(this.node.getLabel() + MimeTypes.extensionOf((String)ComponentDocuments.getInstance().getDocumentContentType(this.node.getId())));
        result.value(NodeHelper.urlOf(this.node));
        result.mimeType(NodeHelper.contentTypeOf(this.node));
        return result;
    }
}

