/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.services;

import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class Response
implements org.monet.http.Response {
    private AlexandriaHttpContext context;
    private FileOutputStream stream;
    private File tempFile;
    private String contentType;
    private String filename;
    private int status;
    private String encoding;

    public Response(AlexandriaHttpContext context) {
        this.context = context;
    }

    public void setContext(AlexandriaHttpContext context) {
        this.context = context;
    }

    public void setContentType(String type) {
        this.context.header("content-type", type);
        this.contentType = type;
    }

    public void setContentLength(int length) {
        this.context.add("content-length", String.valueOf(length));
    }

    public void setHeader(String name, String value) {
        this.context.header(name, value);
        if (name.equals("Content-Disposition")) {
            this.filename = value.substring(value.indexOf("filename=") + 9);
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream();
    }

    public PrintWriter getWriter() {
        return new PrintWriter(this.outputStream());
    }

    public void setCharacterEncoding(String encoding) {
        this.encoding = encoding;
    }

    public InputStream stream() {
        try {
            if (this.stream == null) {
                return null;
            }
            this.stream.close();
            return new FileInputStream(this.tempFile);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void deleteTempFile() {
        if (this.tempFile == null) {
            return;
        }
        this.tempFile.delete();
    }

    private FileOutputStream outputStream() {
        if (this.stream == null) {
            try {
                this.tempFile = File.createTempFile("goros-response", null);
                this.stream = new FileOutputStream(this.tempFile);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

