/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.rest.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.actions.PostMailboxAction;

public class PostMailboxResource
implements Resource {
    private UnitBox box;
    private AlexandriaHttpManager<PushService<?, ?>> manager;

    public PostMailboxResource(UnitBox box, AlexandriaHttpManager manager) {
        this.box = box;
        this.manager = manager;
    }

    public void execute() throws AlexandriaException {
        this.write(this.fill(new PostMailboxAction()).execute());
    }

    private PostMailboxAction fill(PostMailboxAction action) throws AlexandriaException {
        action.box = this.box;
        action.context = this.context();
        try {
            action.address = (String)RequestAdapter.adapt((String)this.manager.fromPath("address"), String.class);
            action.signaling = (String)RequestAdapter.adapt((String)this.manager.fromQuery("signaling"), String.class);
            action.message = this.manager.fromFormAsResource("message");
            action.messageCode = (String)RequestAdapter.adapt((String)this.manager.fromQuery("message-code"), String.class);
            action.messageType = (String)RequestAdapter.adapt((String)this.manager.fromQuery("message-type"), String.class);
            action.messageHash = (String)RequestAdapter.adapt((String)this.manager.fromQuery("message-hash"), String.class);
        }
        catch (Throwable e) {
            action.onMalformedRequest(e);
        }
        return action;
    }

    private void write(String object) {
        this.manager.write((Object)ResponseAdapter.adapt((Object)object));
    }

    private AlexandriaHttpContext context() {
        AlexandriaHttpContext context = new AlexandriaHttpContext(this.manager);
        context.put((Object)"pathInfo", (Object)this.manager.request().raw().getPathInfo());
        context.put((Object)"ip", (Object)this.manager.ip());
        return context;
    }
}

